/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.Tag;
import software.amazon.awssdk.services.proton.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, CreateServiceRequest> {
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchName").getter(CreateServiceRequest.getter(CreateServiceRequest::branchName)).setter(CreateServiceRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateServiceRequest.getter(CreateServiceRequest::description)).setter(CreateServiceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateServiceRequest.getter(CreateServiceRequest::name)).setter(CreateServiceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REPOSITORY_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryConnectionArn").getter(CreateServiceRequest.getter(CreateServiceRequest::repositoryConnectionArn)).setter(CreateServiceRequest.setter(Builder::repositoryConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryConnectionArn").build()}).build();
    private static final SdkField<String> REPOSITORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryId").getter(CreateServiceRequest.getter(CreateServiceRequest::repositoryId)).setter(CreateServiceRequest.setter(Builder::repositoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryId").build()}).build();
    private static final SdkField<String> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spec").getter(CreateServiceRequest.getter(CreateServiceRequest::spec)).setter(CreateServiceRequest.setter(Builder::spec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateServiceRequest.getter(CreateServiceRequest::tags)).setter(CreateServiceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMajorVersion").getter(CreateServiceRequest.getter(CreateServiceRequest::templateMajorVersion)).setter(CreateServiceRequest.setter(Builder::templateMajorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMinorVersion").getter(CreateServiceRequest.getter(CreateServiceRequest::templateMinorVersion)).setter(CreateServiceRequest.setter(Builder::templateMinorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(CreateServiceRequest.getter(CreateServiceRequest::templateName)).setter(CreateServiceRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_NAME_FIELD, DESCRIPTION_FIELD, NAME_FIELD, REPOSITORY_CONNECTION_ARN_FIELD, REPOSITORY_ID_FIELD, SPEC_FIELD, TAGS_FIELD, TEMPLATE_MAJOR_VERSION_FIELD, TEMPLATE_MINOR_VERSION_FIELD, TEMPLATE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("branchName", BRANCH_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("name", NAME_FIELD);
            this.put("repositoryConnectionArn", REPOSITORY_CONNECTION_ARN_FIELD);
            this.put("repositoryId", REPOSITORY_ID_FIELD);
            this.put("spec", SPEC_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("templateMajorVersion", TEMPLATE_MAJOR_VERSION_FIELD);
            this.put("templateMinorVersion", TEMPLATE_MINOR_VERSION_FIELD);
            this.put("templateName", TEMPLATE_NAME_FIELD);
        }
    });
    private final String branchName;
    private final String description;
    private final String name;
    private final String repositoryConnectionArn;
    private final String repositoryId;
    private final String spec;
    private final List<Tag> tags;
    private final String templateMajorVersion;
    private final String templateMinorVersion;
    private final String templateName;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.name = builder.name;
        this.repositoryConnectionArn = builder.repositoryConnectionArn;
        this.repositoryId = builder.repositoryId;
        this.spec = builder.spec;
        this.tags = builder.tags;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
        this.templateName = builder.templateName;
    }

    public final String branchName() {
        return this.branchName;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String repositoryConnectionArn() {
        return this.repositoryConnectionArn;
    }

    public final String repositoryId() {
        return this.repositoryId;
    }

    public final String spec() {
        return this.spec;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String templateMajorVersion() {
        return this.templateMajorVersion;
    }

    public final String templateMinorVersion() {
        return this.templateMinorVersion;
    }

    public final String templateName() {
        return this.templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)((Object)obj);
        return Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.repositoryConnectionArn(), other.repositoryConnectionArn()) && Objects.equals(this.repositoryId(), other.repositoryId()) && Objects.equals(this.spec(), other.spec()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateMajorVersion(), other.templateMajorVersion()) && Objects.equals(this.templateMinorVersion(), other.templateMinorVersion()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceRequest").add("BranchName", (Object)this.branchName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("RepositoryConnectionArn", (Object)this.repositoryConnectionArn()).add("RepositoryId", (Object)this.repositoryId()).add("Spec", (Object)(this.spec() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateMajorVersion", (Object)this.templateMajorVersion()).add("TemplateMinorVersion", (Object)this.templateMinorVersion()).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "repositoryConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.repositoryConnectionArn()));
            }
            case "repositoryId": {
                return Optional.ofNullable(clazz.cast(this.repositoryId()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "templateMajorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMajorVersion()));
            }
            case "templateMinorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMinorVersion()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String branchName;
        private String description;
        private String name;
        private String repositoryConnectionArn;
        private String repositoryId;
        private String spec;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String templateMajorVersion;
        private String templateMinorVersion;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            this.branchName(model.branchName);
            this.description(model.description);
            this.name(model.name);
            this.repositoryConnectionArn(model.repositoryConnectionArn);
            this.repositoryId(model.repositoryId);
            this.spec(model.spec);
            this.tags(model.tags);
            this.templateMajorVersion(model.templateMajorVersion);
            this.templateMinorVersion(model.templateMinorVersion);
            this.templateName(model.templateName);
        }

        public final String getBranchName() {
            return this.branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRepositoryConnectionArn() {
            return this.repositoryConnectionArn;
        }

        public final void setRepositoryConnectionArn(String repositoryConnectionArn) {
            this.repositoryConnectionArn = repositoryConnectionArn;
        }

        @Override
        public final Builder repositoryConnectionArn(String repositoryConnectionArn) {
            this.repositoryConnectionArn = repositoryConnectionArn;
            return this;
        }

        public final String getRepositoryId() {
            return this.repositoryId;
        }

        public final void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public final String getSpec() {
            return this.spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateMajorVersion() {
            return this.templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return this.templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceRequest> {
        public Builder branchName(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder repositoryConnectionArn(String var1);

        public Builder repositoryId(String var1);

        public Builder spec(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder templateMajorVersion(String var1);

        public Builder templateMinorVersion(String var1);

        public Builder templateName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

