/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsResponse;
import software.amazon.awssdk.services.proton.model.Output;

public class ListServicePipelineOutputsPublisher
implements SdkPublisher<ListServicePipelineOutputsResponse> {
    private final ProtonAsyncClient client;
    private final ListServicePipelineOutputsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServicePipelineOutputsPublisher(ProtonAsyncClient client, ListServicePipelineOutputsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServicePipelineOutputsPublisher(ProtonAsyncClient client, ListServicePipelineOutputsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServicePipelineOutputsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServicePipelineOutputsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Output> outputs() {
        Function<ListServicePipelineOutputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.outputs() != null) {
                return response.outputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServicePipelineOutputsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServicePipelineOutputsResponseFetcher
    implements AsyncPageFetcher<ListServicePipelineOutputsResponse> {
        private ListServicePipelineOutputsResponseFetcher() {
        }

        public boolean hasNextPage(ListServicePipelineOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServicePipelineOutputsResponse> nextPage(ListServicePipelineOutputsResponse previousPage) {
            if (previousPage == null) {
                return ListServicePipelineOutputsPublisher.this.client.listServicePipelineOutputs(ListServicePipelineOutputsPublisher.this.firstRequest);
            }
            return ListServicePipelineOutputsPublisher.this.client.listServicePipelineOutputs((ListServicePipelineOutputsRequest)((Object)ListServicePipelineOutputsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

