/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ProvisionedResource;

public class ListServiceInstanceProvisionedResourcesPublisher
implements SdkPublisher<ListServiceInstanceProvisionedResourcesResponse> {
    private final ProtonAsyncClient client;
    private final ListServiceInstanceProvisionedResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceInstanceProvisionedResourcesPublisher(ProtonAsyncClient client, ListServiceInstanceProvisionedResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceInstanceProvisionedResourcesPublisher(ProtonAsyncClient client, ListServiceInstanceProvisionedResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceInstanceProvisionedResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceInstanceProvisionedResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProvisionedResource> provisionedResources() {
        Function<ListServiceInstanceProvisionedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedResources() != null) {
                return response.provisionedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceInstanceProvisionedResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceInstanceProvisionedResourcesResponseFetcher
    implements AsyncPageFetcher<ListServiceInstanceProvisionedResourcesResponse> {
        private ListServiceInstanceProvisionedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceInstanceProvisionedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceInstanceProvisionedResourcesResponse> nextPage(ListServiceInstanceProvisionedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceInstanceProvisionedResourcesPublisher.this.client.listServiceInstanceProvisionedResources(ListServiceInstanceProvisionedResourcesPublisher.this.firstRequest);
            }
            return ListServiceInstanceProvisionedResourcesPublisher.this.client.listServiceInstanceProvisionedResources((ListServiceInstanceProvisionedResourcesRequest)((Object)ListServiceInstanceProvisionedResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

