/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse;
import software.amazon.awssdk.services.proton.model.ServiceInstanceSummary;

public class ListServiceInstancesPublisher
implements SdkPublisher<ListServiceInstancesResponse> {
    private final ProtonAsyncClient client;
    private final ListServiceInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceInstancesPublisher(ProtonAsyncClient client, ListServiceInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceInstancesPublisher(ProtonAsyncClient client, ListServiceInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceInstanceSummary> serviceInstances() {
        Function<ListServiceInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceInstances() != null) {
                return response.serviceInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceInstancesResponseFetcher
    implements AsyncPageFetcher<ListServiceInstancesResponse> {
        private ListServiceInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceInstancesResponse> nextPage(ListServiceInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceInstancesPublisher.this.client.listServiceInstances(ListServiceInstancesPublisher.this.firstRequest);
            }
            return ListServiceInstancesPublisher.this.client.listServiceInstances((ListServiceInstancesRequest)((Object)ListServiceInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

