/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.RepositoryProvider;
import software.amazon.awssdk.services.proton.model.SyncType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRepositorySyncStatusRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, GetRepositorySyncStatusRequest> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branch").getter(GetRepositorySyncStatusRequest.getter(GetRepositorySyncStatusRequest::branch)).setter(GetRepositorySyncStatusRequest.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(GetRepositorySyncStatusRequest.getter(GetRepositorySyncStatusRequest::repositoryName)).setter(GetRepositorySyncStatusRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> REPOSITORY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryProvider").getter(GetRepositorySyncStatusRequest.getter(GetRepositorySyncStatusRequest::repositoryProviderAsString)).setter(GetRepositorySyncStatusRequest.setter(Builder::repositoryProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryProvider").build()}).build();
    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncType").getter(GetRepositorySyncStatusRequest.getter(GetRepositorySyncStatusRequest::syncTypeAsString)).setter(GetRepositorySyncStatusRequest.setter(Builder::syncType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_PROVIDER_FIELD, SYNC_TYPE_FIELD));
    private final String branch;
    private final String repositoryName;
    private final String repositoryProvider;
    private final String syncType;

    private GetRepositorySyncStatusRequest(BuilderImpl builder) {
        super(builder);
        this.branch = builder.branch;
        this.repositoryName = builder.repositoryName;
        this.repositoryProvider = builder.repositoryProvider;
        this.syncType = builder.syncType;
    }

    public final String branch() {
        return this.branch;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final RepositoryProvider repositoryProvider() {
        return RepositoryProvider.fromValue(this.repositoryProvider);
    }

    public final String repositoryProviderAsString() {
        return this.repositoryProvider;
    }

    public final SyncType syncType() {
        return SyncType.fromValue(this.syncType);
    }

    public final String syncTypeAsString() {
        return this.syncType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRepositorySyncStatusRequest)) {
            return false;
        }
        GetRepositorySyncStatusRequest other = (GetRepositorySyncStatusRequest)((Object)obj);
        return Objects.equals(this.branch(), other.branch()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.repositoryProviderAsString(), other.repositoryProviderAsString()) && Objects.equals(this.syncTypeAsString(), other.syncTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetRepositorySyncStatusRequest").add("Branch", (Object)this.branch()).add("RepositoryName", (Object)this.repositoryName()).add("RepositoryProvider", (Object)this.repositoryProviderAsString()).add("SyncType", (Object)this.syncTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "repositoryProvider": {
                return Optional.ofNullable(clazz.cast(this.repositoryProviderAsString()));
            }
            case "syncType": {
                return Optional.ofNullable(clazz.cast(this.syncTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRepositorySyncStatusRequest, T> g) {
        return obj -> g.apply((GetRepositorySyncStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String branch;
        private String repositoryName;
        private String repositoryProvider;
        private String syncType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRepositorySyncStatusRequest model) {
            super(model);
            this.branch(model.branch);
            this.repositoryName(model.repositoryName);
            this.repositoryProvider(model.repositoryProvider);
            this.syncType(model.syncType);
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        @Transient
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryProvider() {
            return this.repositoryProvider;
        }

        public final void setRepositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
        }

        @Override
        @Transient
        public final Builder repositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        @Override
        @Transient
        public final Builder repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider(repositoryProvider == null ? null : repositoryProvider.toString());
            return this;
        }

        public final String getSyncType() {
            return this.syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        @Transient
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        @Transient
        public final Builder syncType(SyncType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRepositorySyncStatusRequest build() {
            return new GetRepositorySyncStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRepositorySyncStatusRequest> {
        public Builder branch(String var1);

        public Builder repositoryName(String var1);

        public Builder repositoryProvider(String var1);

        public Builder repositoryProvider(RepositoryProvider var1);

        public Builder syncType(String var1);

        public Builder syncType(SyncType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

