/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput;
import software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInputListCopier;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.TemplateVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceTemplateVersionRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, UpdateServiceTemplateVersionRequest> {
    private static final SdkField<List<CompatibleEnvironmentTemplateInput>> COMPATIBLE_ENVIRONMENT_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("compatibleEnvironmentTemplates").getter(UpdateServiceTemplateVersionRequest.getter(UpdateServiceTemplateVersionRequest::compatibleEnvironmentTemplates)).setter(UpdateServiceTemplateVersionRequest.setter(Builder::compatibleEnvironmentTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleEnvironmentTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompatibleEnvironmentTemplateInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateServiceTemplateVersionRequest.getter(UpdateServiceTemplateVersionRequest::description)).setter(UpdateServiceTemplateVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("majorVersion").getter(UpdateServiceTemplateVersionRequest.getter(UpdateServiceTemplateVersionRequest::majorVersion)).setter(UpdateServiceTemplateVersionRequest.setter(Builder::majorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()}).build();
    private static final SdkField<String> MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("minorVersion").getter(UpdateServiceTemplateVersionRequest.getter(UpdateServiceTemplateVersionRequest::minorVersion)).setter(UpdateServiceTemplateVersionRequest.setter(Builder::minorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minorVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateServiceTemplateVersionRequest.getter(UpdateServiceTemplateVersionRequest::statusAsString)).setter(UpdateServiceTemplateVersionRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(UpdateServiceTemplateVersionRequest.getter(UpdateServiceTemplateVersionRequest::templateName)).setter(UpdateServiceTemplateVersionRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_ENVIRONMENT_TEMPLATES_FIELD, DESCRIPTION_FIELD, MAJOR_VERSION_FIELD, MINOR_VERSION_FIELD, STATUS_FIELD, TEMPLATE_NAME_FIELD));
    private final List<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates;
    private final String description;
    private final String majorVersion;
    private final String minorVersion;
    private final String status;
    private final String templateName;

    private UpdateServiceTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.compatibleEnvironmentTemplates = builder.compatibleEnvironmentTemplates;
        this.description = builder.description;
        this.majorVersion = builder.majorVersion;
        this.minorVersion = builder.minorVersion;
        this.status = builder.status;
        this.templateName = builder.templateName;
    }

    public final boolean hasCompatibleEnvironmentTemplates() {
        return this.compatibleEnvironmentTemplates != null && !(this.compatibleEnvironmentTemplates instanceof SdkAutoConstructList);
    }

    public final List<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates() {
        return this.compatibleEnvironmentTemplates;
    }

    public final String description() {
        return this.description;
    }

    public final String majorVersion() {
        return this.majorVersion;
    }

    public final String minorVersion() {
        return this.minorVersion;
    }

    public final TemplateVersionStatus status() {
        return TemplateVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String templateName() {
        return this.templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibleEnvironmentTemplates() ? this.compatibleEnvironmentTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceTemplateVersionRequest)) {
            return false;
        }
        UpdateServiceTemplateVersionRequest other = (UpdateServiceTemplateVersionRequest)((Object)obj);
        return this.hasCompatibleEnvironmentTemplates() == other.hasCompatibleEnvironmentTemplates() && Objects.equals(this.compatibleEnvironmentTemplates(), other.compatibleEnvironmentTemplates()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.majorVersion(), other.majorVersion()) && Objects.equals(this.minorVersion(), other.minorVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceTemplateVersionRequest").add("CompatibleEnvironmentTemplates", this.hasCompatibleEnvironmentTemplates() ? this.compatibleEnvironmentTemplates() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("MajorVersion", (Object)this.majorVersion()).add("MinorVersion", (Object)this.minorVersion()).add("Status", (Object)this.statusAsString()).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "compatibleEnvironmentTemplates": {
                return Optional.ofNullable(clazz.cast(this.compatibleEnvironmentTemplates()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "majorVersion": {
                return Optional.ofNullable(clazz.cast(this.majorVersion()));
            }
            case "minorVersion": {
                return Optional.ofNullable(clazz.cast(this.minorVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceTemplateVersionRequest, T> g) {
        return obj -> g.apply((UpdateServiceTemplateVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private List<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String majorVersion;
        private String minorVersion;
        private String status;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceTemplateVersionRequest model) {
            super(model);
            this.compatibleEnvironmentTemplates(model.compatibleEnvironmentTemplates);
            this.description(model.description);
            this.majorVersion(model.majorVersion);
            this.minorVersion(model.minorVersion);
            this.status(model.status);
            this.templateName(model.templateName);
        }

        public final List<CompatibleEnvironmentTemplateInput.Builder> getCompatibleEnvironmentTemplates() {
            List<CompatibleEnvironmentTemplateInput.Builder> result = CompatibleEnvironmentTemplateInputListCopier.copyToBuilder(this.compatibleEnvironmentTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder compatibleEnvironmentTemplates(Collection<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates = CompatibleEnvironmentTemplateInputListCopier.copy(compatibleEnvironmentTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleEnvironmentTemplates(CompatibleEnvironmentTemplateInput ... compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates(Arrays.asList(compatibleEnvironmentTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleEnvironmentTemplates(Consumer<CompatibleEnvironmentTemplateInput.Builder> ... compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates(Stream.of(compatibleEnvironmentTemplates).map(c -> (CompatibleEnvironmentTemplateInput)((CompatibleEnvironmentTemplateInput.Builder)CompatibleEnvironmentTemplateInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCompatibleEnvironmentTemplates(Collection<CompatibleEnvironmentTemplateInput.BuilderImpl> compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates = CompatibleEnvironmentTemplateInputListCopier.copyFromBuilder(compatibleEnvironmentTemplates);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getMajorVersion() {
            return this.majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        public final String getMinorVersion() {
            return this.minorVersion;
        }

        @Override
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceTemplateVersionRequest build() {
            return new UpdateServiceTemplateVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceTemplateVersionRequest> {
        public Builder compatibleEnvironmentTemplates(Collection<CompatibleEnvironmentTemplateInput> var1);

        public Builder compatibleEnvironmentTemplates(CompatibleEnvironmentTemplateInput ... var1);

        public Builder compatibleEnvironmentTemplates(Consumer<CompatibleEnvironmentTemplateInput.Builder> ... var1);

        public Builder description(String var1);

        public Builder majorVersion(String var1);

        public Builder minorVersion(String var1);

        public Builder status(String var1);

        public Builder status(TemplateVersionStatus var1);

        public Builder templateName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

