/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocolquery.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolquery.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolquery.model.EmptyModeledException;
import software.amazon.awssdk.services.protocolquery.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolquery.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolquery.model.ProtocolQueryException;
import software.amazon.awssdk.services.protocolquery.model.QueryTypesRequest;
import software.amazon.awssdk.services.protocolquery.model.QueryTypesResponse;

/**
 * Service client for accessing AmazonProtocolQuery. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolQueryClient extends SdkClient {
    String SERVICE_NAME = "query";

    /**
     * Create a {@link ProtocolQueryClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ProtocolQueryClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolQueryClient}.
     */
    static ProtocolQueryClientBuilder builder() {
        return new DefaultProtocolQueryClientBuilder();
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolQueryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolQueryClient.AllTypes
     * @see #allTypes(AllTypesRequest)
     */
    default AllTypesResponse allTypes() throws EmptyModeledException, AwsServiceException, SdkClientException,
            ProtocolQueryException {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolQueryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolQueryClient.AllTypes
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws EmptyModeledException, AwsServiceException,
            SdkClientException, ProtocolQueryException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllTypesRequest.Builder} avoiding the need to
     * create one manually via {@link AllTypesRequest#builder()}
     * </p>
     *
     * @param allTypesRequest
     *        A {@link Consumer} that will call methods on {@link AllTypesStructure.Builder} to create a request.
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolQueryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolQueryClient.AllTypes
     */
    default AllTypesResponse allTypes(Consumer<AllTypesRequest.Builder> allTypesRequest) throws EmptyModeledException,
            AwsServiceException, SdkClientException, ProtocolQueryException {
        return allTypes(AllTypesRequest.builder().applyMutation(allTypesRequest).build());
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolQueryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolQueryClient.IdempotentOperation
     * @see #idempotentOperation(IdempotentOperationRequest)
     */
    default IdempotentOperationResponse idempotentOperation() throws AwsServiceException, SdkClientException,
            ProtocolQueryException {
        return idempotentOperation(IdempotentOperationRequest.builder().build());
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolQueryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolQueryClient.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws AwsServiceException, SdkClientException, ProtocolQueryException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IdempotentOperationRequest.Builder} avoiding the
     * need to create one manually via {@link IdempotentOperationRequest#builder()}
     * </p>
     *
     * @param idempotentOperationRequest
     *        A {@link Consumer} that will call methods on {@link IdempotentOperationStructure.Builder} to create a
     *        request.
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolQueryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolQueryClient.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation(
            Consumer<IdempotentOperationRequest.Builder> idempotentOperationRequest) throws AwsServiceException,
            SdkClientException, ProtocolQueryException {
        return idempotentOperation(IdempotentOperationRequest.builder().applyMutation(idempotentOperationRequest).build());
    }

    /**
     * Invokes the QueryTypes operation.
     *
     * @return Result of the QueryTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolQueryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolQueryClient.QueryTypes
     * @see #queryTypes(QueryTypesRequest)
     */
    default QueryTypesResponse queryTypes() throws AwsServiceException, SdkClientException, ProtocolQueryException {
        return queryTypes(QueryTypesRequest.builder().build());
    }

    /**
     * Invokes the QueryTypes operation.
     *
     * @param queryTypesRequest
     * @return Result of the QueryTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolQueryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolQueryClient.QueryTypes
     */
    default QueryTypesResponse queryTypes(QueryTypesRequest queryTypesRequest) throws AwsServiceException, SdkClientException,
            ProtocolQueryException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the QueryTypes operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryTypesRequest.Builder} avoiding the need to
     * create one manually via {@link QueryTypesRequest#builder()}
     * </p>
     *
     * @param queryTypesRequest
     *        A {@link Consumer} that will call methods on {@link QueryTypesInput.Builder} to create a request.
     * @return Result of the QueryTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolQueryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolQueryClient.QueryTypes
     */
    default QueryTypesResponse queryTypes(Consumer<QueryTypesRequest.Builder> queryTypesRequest) throws AwsServiceException,
            SdkClientException, ProtocolQueryException {
        return queryTypes(QueryTypesRequest.builder().applyMutation(queryTypesRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("query");
    }
}
