/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery.transform;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolquery.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * AllTypesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AllTypesRequestMarshaller implements Marshaller<Request<AllTypesRequest>, AllTypesRequest> {

    public Request<AllTypesRequest> marshall(AllTypesRequest allTypesRequest) {

        if (allTypesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<AllTypesRequest> request = new DefaultRequest<AllTypesRequest>(allTypesRequest, "ProtocolQueryClient");
        request.addParameter("Action", "AllTypes");
        request.addParameter("Version", "2016-03-11");
        request.setHttpMethod(HttpMethodName.POST);

        if (allTypesRequest.stringMember() != null) {
            request.addParameter("stringMember", StringConversion.fromString(allTypesRequest.stringMember()));
        }

        if (allTypesRequest.integerMember() != null) {
            request.addParameter("integerMember", StringConversion.fromInteger(allTypesRequest.integerMember()));
        }

        if (allTypesRequest.booleanMember() != null) {
            request.addParameter("booleanMember", StringConversion.fromBoolean(allTypesRequest.booleanMember()));
        }

        if (allTypesRequest.floatMember() != null) {
            request.addParameter("floatMember", StringConversion.fromFloat(allTypesRequest.floatMember()));
        }

        if (allTypesRequest.doubleMember() != null) {
            request.addParameter("doubleMember", StringConversion.fromDouble(allTypesRequest.doubleMember()));
        }

        if (allTypesRequest.longMember() != null) {
            request.addParameter("longMember", StringConversion.fromLong(allTypesRequest.longMember()));
        }

        SimpleStruct simpleStructMember = allTypesRequest.simpleStructMember();
        if (simpleStructMember != null) {

            if (simpleStructMember.stringMember() != null) {
                request.addParameter("simpleStructMember.StringMember",
                        StringConversion.fromString(simpleStructMember.stringMember()));
            }
        }

        if (allTypesRequest.simpleList() != null) {
            java.util.List<String> simpleListList = allTypesRequest.simpleList();
            if (simpleListList.isEmpty()) {
                request.addParameter("simpleList", "");
            } else {
                int simpleListListIndex = 1;

                for (String simpleListListValue : simpleListList) {
                    if (simpleListListValue != null) {
                        request.addParameter("simpleList.member." + simpleListListIndex,
                                StringConversion.fromString(simpleListListValue));
                    }
                    simpleListListIndex++;
                }
            }
        }

        if (allTypesRequest.listOfStructs() != null) {
            java.util.List<SimpleStruct> listOfStructsList = allTypesRequest.listOfStructs();
            if (listOfStructsList.isEmpty()) {
                request.addParameter("listOfStructs", "");
            } else {
                int listOfStructsListIndex = 1;

                for (SimpleStruct listOfStructsListValue : listOfStructsList) {

                    if (listOfStructsListValue.stringMember() != null) {
                        request.addParameter("listOfStructs.member." + listOfStructsListIndex + ".StringMember",
                                StringConversion.fromString(listOfStructsListValue.stringMember()));
                    }
                    listOfStructsListIndex++;
                }
            }
        }

        java.util.Map<String, String> mapOfStringToString = allTypesRequest.mapOfStringToString();

        if (mapOfStringToString != null) {
            int mapOfStringToStringListIndex = 1;
            for (Map.Entry<String, String> entry : mapOfStringToString.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("mapOfStringToString.entry." + mapOfStringToStringListIndex + ".key",
                            StringConversion.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("mapOfStringToString.entry." + mapOfStringToStringListIndex + ".value",
                            StringConversion.fromString(entry.getValue()));
                }
                mapOfStringToStringListIndex++;
            }
        }

        if (allTypesRequest.timestampMember() != null) {
            request.addParameter("timestampMember", StringConversion.fromInstant(allTypesRequest.timestampMember()));
        }

        StructWithTimestamp structWithNestedTimestampMember = allTypesRequest.structWithNestedTimestampMember();
        if (structWithNestedTimestampMember != null) {

            if (structWithNestedTimestampMember.nestedTimestamp() != null) {
                request.addParameter("structWithNestedTimestampMember.NestedTimestamp",
                        StringConversion.fromInstant(structWithNestedTimestampMember.nestedTimestamp()));
            }
        }

        if (allTypesRequest.blobArg() != null) {
            request.addParameter("blobArg", StringConversion.fromSdkBytes(allTypesRequest.blobArg()));
        }

        java.util.Map<String, software.amazon.awssdk.core.SdkBytes> blobMap = allTypesRequest.blobMap();

        if (blobMap != null) {
            int blobMapListIndex = 1;
            for (Map.Entry<String, software.amazon.awssdk.core.SdkBytes> entry : blobMap.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("blobMap.entry." + blobMapListIndex + ".key",
                            StringConversion.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("blobMap.entry." + blobMapListIndex + ".value",
                            StringConversion.fromSdkBytes(entry.getValue()));
                }
                blobMapListIndex++;
            }
        }

        if (allTypesRequest.listOfBlobs() != null) {
            java.util.List<software.amazon.awssdk.core.SdkBytes> listOfBlobsList = allTypesRequest.listOfBlobs();
            if (listOfBlobsList.isEmpty()) {
                request.addParameter("listOfBlobs", "");
            } else {
                int listOfBlobsListIndex = 1;

                for (software.amazon.awssdk.core.SdkBytes listOfBlobsListValue : listOfBlobsList) {
                    if (listOfBlobsListValue != null) {
                        request.addParameter("listOfBlobs.member." + listOfBlobsListIndex,
                                StringConversion.fromSdkBytes(listOfBlobsListValue));
                    }
                    listOfBlobsListIndex++;
                }
            }
        }

        return request;
    }

}
