/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolrestxml.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * OperationWithModeledContentTypeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class OperationWithModeledContentTypeRequestMarshaller implements
        Marshaller<Request<OperationWithModeledContentTypeRequest>, OperationWithModeledContentTypeRequest> {

    public Request<OperationWithModeledContentTypeRequest> marshall(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) {

        if (operationWithModeledContentTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<OperationWithModeledContentTypeRequest> request = new DefaultRequest<OperationWithModeledContentTypeRequest>(
                operationWithModeledContentTypeRequest, "ProtocolRestXmlClient");

        request.setHttpMethod(HttpMethodName.POST);

        if (operationWithModeledContentTypeRequest.contentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString(operationWithModeledContentTypeRequest.contentType()));
        }

        String uriResourcePath = "/2016-03-11/operationWithModeledContentType";

        request.setResourcePath(uriResourcePath);

        return request;
    }

}