/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.transform;

import java.util.Map;
import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.protocolrestjson.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * AllTypesRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class AllTypesRequestModelMarshaller {

    private static final MarshallingInfo<String> STRINGMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringMember").build();
    private static final MarshallingInfo<Integer> INTEGERMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegerMember").build();
    private static final MarshallingInfo<Boolean> BOOLEANMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BooleanMember").build();
    private static final MarshallingInfo<Float> FLOATMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FloatMember").build();
    private static final MarshallingInfo<Double> DOUBLEMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DoubleMember").build();
    private static final MarshallingInfo<Long> LONGMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LongMember").build();
    private static final MarshallingInfo<List> SIMPLELIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SimpleList").build();
    private static final MarshallingInfo<List> LISTOFMAPS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListOfMaps").build();
    private static final MarshallingInfo<List> LISTOFSTRUCTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListOfStructs").build();
    private static final MarshallingInfo<Map> MAPOFSTRINGTOINTEGERLIST_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MapOfStringToIntegerList").build();
    private static final MarshallingInfo<Map> MAPOFSTRINGTOSTRING_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MapOfStringToString").build();
    private static final MarshallingInfo<Map> MAPOFSTRINGTOSTRUCT_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MapOfStringToStruct").build();
    private static final MarshallingInfo<java.time.Instant> TIMESTAMPMEMBER_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimestampMember")
            .build();
    private static final MarshallingInfo<StructuredPojo> STRUCTWITHNESTEDTIMESTAMPMEMBER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("StructWithNestedTimestampMember").build();
    private static final MarshallingInfo<java.nio.ByteBuffer> BLOBARG_BINDING = MarshallingInfo
            .builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlobArg")
            .build();
    private static final MarshallingInfo<StructuredPojo> STRUCTWITHNESTEDBLOB_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("StructWithNestedBlob").build();
    private static final MarshallingInfo<Map> BLOBMAP_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlobMap").build();
    private static final MarshallingInfo<List> LISTOFBLOBS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListOfBlobs").build();
    private static final MarshallingInfo<StructuredPojo> RECURSIVESTRUCT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RecursiveStruct").build();
    private static final MarshallingInfo<StructuredPojo> POLYMORPHICTYPEWITHSUBTYPES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("PolymorphicTypeWithSubTypes").build();
    private static final MarshallingInfo<StructuredPojo> POLYMORPHICTYPEWITHOUTSUBTYPES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("PolymorphicTypeWithoutSubTypes").build();

    private static final AllTypesRequestModelMarshaller INSTANCE = new AllTypesRequestModelMarshaller();

    public static AllTypesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AllTypesRequest allTypesRequest, ProtocolMarshaller protocolMarshaller) {

        if (allTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(allTypesRequest.stringMember(), STRINGMEMBER_BINDING);

            protocolMarshaller.marshall(allTypesRequest.integerMember(), INTEGERMEMBER_BINDING);

            protocolMarshaller.marshall(allTypesRequest.booleanMember(), BOOLEANMEMBER_BINDING);

            protocolMarshaller.marshall(allTypesRequest.floatMember(), FLOATMEMBER_BINDING);

            protocolMarshaller.marshall(allTypesRequest.doubleMember(), DOUBLEMEMBER_BINDING);

            protocolMarshaller.marshall(allTypesRequest.longMember(), LONGMEMBER_BINDING);

            protocolMarshaller.marshall(allTypesRequest.simpleList(), SIMPLELIST_BINDING);

            protocolMarshaller.marshall(allTypesRequest.listOfMaps(), LISTOFMAPS_BINDING);

            protocolMarshaller.marshall(allTypesRequest.listOfStructs(), LISTOFSTRUCTS_BINDING);

            protocolMarshaller.marshall(allTypesRequest.mapOfStringToIntegerList(), MAPOFSTRINGTOINTEGERLIST_BINDING);

            protocolMarshaller.marshall(allTypesRequest.mapOfStringToString(), MAPOFSTRINGTOSTRING_BINDING);

            protocolMarshaller.marshall(allTypesRequest.mapOfStringToStruct(), MAPOFSTRINGTOSTRUCT_BINDING);

            protocolMarshaller.marshall(allTypesRequest.timestampMember(), TIMESTAMPMEMBER_BINDING);

            protocolMarshaller.marshall(allTypesRequest.structWithNestedTimestampMember(),
                    STRUCTWITHNESTEDTIMESTAMPMEMBER_BINDING);

            protocolMarshaller.marshall(allTypesRequest.blobArg(), BLOBARG_BINDING);

            protocolMarshaller.marshall(allTypesRequest.structWithNestedBlob(), STRUCTWITHNESTEDBLOB_BINDING);

            protocolMarshaller.marshall(allTypesRequest.blobMap(), BLOBMAP_BINDING);

            protocolMarshaller.marshall(allTypesRequest.listOfBlobs(), LISTOFBLOBS_BINDING);

            protocolMarshaller.marshall(allTypesRequest.recursiveStruct(), RECURSIVESTRUCT_BINDING);

            protocolMarshaller.marshall(allTypesRequest.polymorphicTypeWithSubTypes(), POLYMORPHICTYPEWITHSUBTYPES_BINDING);

            protocolMarshaller.marshall(allTypesRequest.polymorphicTypeWithoutSubTypes(), POLYMORPHICTYPEWITHOUTSUBTYPES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
