/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MembersInQueryParamsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<MembersInQueryParamsRequest.Builder, MembersInQueryParamsRequest> {
    private final String stringQueryParam;

    private final Boolean booleanQueryParam;

    private final Integer integerQueryParam;

    private final Long longQueryParam;

    private final Float floatQueryParam;

    private final Double doubleQueryParam;

    private final Instant timestampQueryParam;

    private final List<String> listOfStrings;

    private final Map<String, String> mapOfStringToString;

    private MembersInQueryParamsRequest(BuilderImpl builder) {
        this.stringQueryParam = builder.stringQueryParam;
        this.booleanQueryParam = builder.booleanQueryParam;
        this.integerQueryParam = builder.integerQueryParam;
        this.longQueryParam = builder.longQueryParam;
        this.floatQueryParam = builder.floatQueryParam;
        this.doubleQueryParam = builder.doubleQueryParam;
        this.timestampQueryParam = builder.timestampQueryParam;
        this.listOfStrings = builder.listOfStrings;
        this.mapOfStringToString = builder.mapOfStringToString;
    }

    /**
     * Returns the value of the StringQueryParam property for this object.
     * 
     * @return The value of the StringQueryParam property for this object.
     */
    public String stringQueryParam() {
        return stringQueryParam;
    }

    /**
     * Returns the value of the BooleanQueryParam property for this object.
     * 
     * @return The value of the BooleanQueryParam property for this object.
     */
    public Boolean booleanQueryParam() {
        return booleanQueryParam;
    }

    /**
     * Returns the value of the IntegerQueryParam property for this object.
     * 
     * @return The value of the IntegerQueryParam property for this object.
     */
    public Integer integerQueryParam() {
        return integerQueryParam;
    }

    /**
     * Returns the value of the LongQueryParam property for this object.
     * 
     * @return The value of the LongQueryParam property for this object.
     */
    public Long longQueryParam() {
        return longQueryParam;
    }

    /**
     * Returns the value of the FloatQueryParam property for this object.
     * 
     * @return The value of the FloatQueryParam property for this object.
     */
    public Float floatQueryParam() {
        return floatQueryParam;
    }

    /**
     * Returns the value of the DoubleQueryParam property for this object.
     * 
     * @return The value of the DoubleQueryParam property for this object.
     */
    public Double doubleQueryParam() {
        return doubleQueryParam;
    }

    /**
     * Returns the value of the TimestampQueryParam property for this object.
     * 
     * @return The value of the TimestampQueryParam property for this object.
     */
    public Instant timestampQueryParam() {
        return timestampQueryParam;
    }

    /**
     * Returns the value of the ListOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListOfStrings property for this object.
     */
    public List<String> listOfStrings() {
        return listOfStrings;
    }

    /**
     * Returns the value of the MapOfStringToString property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the MapOfStringToString property for this object.
     */
    public Map<String, String> mapOfStringToString() {
        return mapOfStringToString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stringQueryParam() == null) ? 0 : stringQueryParam().hashCode());
        hashCode = 31 * hashCode + ((booleanQueryParam() == null) ? 0 : booleanQueryParam().hashCode());
        hashCode = 31 * hashCode + ((integerQueryParam() == null) ? 0 : integerQueryParam().hashCode());
        hashCode = 31 * hashCode + ((longQueryParam() == null) ? 0 : longQueryParam().hashCode());
        hashCode = 31 * hashCode + ((floatQueryParam() == null) ? 0 : floatQueryParam().hashCode());
        hashCode = 31 * hashCode + ((doubleQueryParam() == null) ? 0 : doubleQueryParam().hashCode());
        hashCode = 31 * hashCode + ((timestampQueryParam() == null) ? 0 : timestampQueryParam().hashCode());
        hashCode = 31 * hashCode + ((listOfStrings() == null) ? 0 : listOfStrings().hashCode());
        hashCode = 31 * hashCode + ((mapOfStringToString() == null) ? 0 : mapOfStringToString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembersInQueryParamsRequest)) {
            return false;
        }
        MembersInQueryParamsRequest other = (MembersInQueryParamsRequest) obj;
        if (other.stringQueryParam() == null ^ this.stringQueryParam() == null) {
            return false;
        }
        if (other.stringQueryParam() != null && !other.stringQueryParam().equals(this.stringQueryParam())) {
            return false;
        }
        if (other.booleanQueryParam() == null ^ this.booleanQueryParam() == null) {
            return false;
        }
        if (other.booleanQueryParam() != null && !other.booleanQueryParam().equals(this.booleanQueryParam())) {
            return false;
        }
        if (other.integerQueryParam() == null ^ this.integerQueryParam() == null) {
            return false;
        }
        if (other.integerQueryParam() != null && !other.integerQueryParam().equals(this.integerQueryParam())) {
            return false;
        }
        if (other.longQueryParam() == null ^ this.longQueryParam() == null) {
            return false;
        }
        if (other.longQueryParam() != null && !other.longQueryParam().equals(this.longQueryParam())) {
            return false;
        }
        if (other.floatQueryParam() == null ^ this.floatQueryParam() == null) {
            return false;
        }
        if (other.floatQueryParam() != null && !other.floatQueryParam().equals(this.floatQueryParam())) {
            return false;
        }
        if (other.doubleQueryParam() == null ^ this.doubleQueryParam() == null) {
            return false;
        }
        if (other.doubleQueryParam() != null && !other.doubleQueryParam().equals(this.doubleQueryParam())) {
            return false;
        }
        if (other.timestampQueryParam() == null ^ this.timestampQueryParam() == null) {
            return false;
        }
        if (other.timestampQueryParam() != null && !other.timestampQueryParam().equals(this.timestampQueryParam())) {
            return false;
        }
        if (other.listOfStrings() == null ^ this.listOfStrings() == null) {
            return false;
        }
        if (other.listOfStrings() != null && !other.listOfStrings().equals(this.listOfStrings())) {
            return false;
        }
        if (other.mapOfStringToString() == null ^ this.mapOfStringToString() == null) {
            return false;
        }
        if (other.mapOfStringToString() != null && !other.mapOfStringToString().equals(this.mapOfStringToString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stringQueryParam() != null) {
            sb.append("StringQueryParam: ").append(stringQueryParam()).append(",");
        }
        if (booleanQueryParam() != null) {
            sb.append("BooleanQueryParam: ").append(booleanQueryParam()).append(",");
        }
        if (integerQueryParam() != null) {
            sb.append("IntegerQueryParam: ").append(integerQueryParam()).append(",");
        }
        if (longQueryParam() != null) {
            sb.append("LongQueryParam: ").append(longQueryParam()).append(",");
        }
        if (floatQueryParam() != null) {
            sb.append("FloatQueryParam: ").append(floatQueryParam()).append(",");
        }
        if (doubleQueryParam() != null) {
            sb.append("DoubleQueryParam: ").append(doubleQueryParam()).append(",");
        }
        if (timestampQueryParam() != null) {
            sb.append("TimestampQueryParam: ").append(timestampQueryParam()).append(",");
        }
        if (listOfStrings() != null) {
            sb.append("ListOfStrings: ").append(listOfStrings()).append(",");
        }
        if (mapOfStringToString() != null) {
            sb.append("MapOfStringToString: ").append(mapOfStringToString()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MembersInQueryParamsRequest> {
        /**
         * Sets the value of the StringQueryParam property for this object.
         *
         * @param stringQueryParam
         *        The new value for the StringQueryParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringQueryParam(String stringQueryParam);

        /**
         * Sets the value of the BooleanQueryParam property for this object.
         *
         * @param booleanQueryParam
         *        The new value for the BooleanQueryParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanQueryParam(Boolean booleanQueryParam);

        /**
         * Sets the value of the IntegerQueryParam property for this object.
         *
         * @param integerQueryParam
         *        The new value for the IntegerQueryParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerQueryParam(Integer integerQueryParam);

        /**
         * Sets the value of the LongQueryParam property for this object.
         *
         * @param longQueryParam
         *        The new value for the LongQueryParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longQueryParam(Long longQueryParam);

        /**
         * Sets the value of the FloatQueryParam property for this object.
         *
         * @param floatQueryParam
         *        The new value for the FloatQueryParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder floatQueryParam(Float floatQueryParam);

        /**
         * Sets the value of the DoubleQueryParam property for this object.
         *
         * @param doubleQueryParam
         *        The new value for the DoubleQueryParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleQueryParam(Double doubleQueryParam);

        /**
         * Sets the value of the TimestampQueryParam property for this object.
         *
         * @param timestampQueryParam
         *        The new value for the TimestampQueryParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampQueryParam(Instant timestampQueryParam);

        /**
         * Sets the value of the ListOfStrings property for this object.
         *
         * @param listOfStrings
         *        The new value for the ListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStrings(Collection<String> listOfStrings);

        /**
         * Sets the value of the ListOfStrings property for this object.
         *
         * @param listOfStrings
         *        The new value for the ListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStrings(String... listOfStrings);

        /**
         * Sets the value of the MapOfStringToString property for this object.
         *
         * @param mapOfStringToString
         *        The new value for the MapOfStringToString property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapOfStringToString(Map<String, String> mapOfStringToString);
    }

    private static final class BuilderImpl implements Builder {
        private String stringQueryParam;

        private Boolean booleanQueryParam;

        private Integer integerQueryParam;

        private Long longQueryParam;

        private Float floatQueryParam;

        private Double doubleQueryParam;

        private Instant timestampQueryParam;

        private List<String> listOfStrings;

        private Map<String, String> mapOfStringToString;

        private BuilderImpl() {
        }

        private BuilderImpl(MembersInQueryParamsRequest model) {
            setStringQueryParam(model.stringQueryParam);
            setBooleanQueryParam(model.booleanQueryParam);
            setIntegerQueryParam(model.integerQueryParam);
            setLongQueryParam(model.longQueryParam);
            setFloatQueryParam(model.floatQueryParam);
            setDoubleQueryParam(model.doubleQueryParam);
            setTimestampQueryParam(model.timestampQueryParam);
            setListOfStrings(model.listOfStrings);
            setMapOfStringToString(model.mapOfStringToString);
        }

        public final String getStringQueryParam() {
            return stringQueryParam;
        }

        @Override
        public final Builder stringQueryParam(String stringQueryParam) {
            this.stringQueryParam = stringQueryParam;
            return this;
        }

        public final void setStringQueryParam(String stringQueryParam) {
            this.stringQueryParam = stringQueryParam;
        }

        public final Boolean getBooleanQueryParam() {
            return booleanQueryParam;
        }

        @Override
        public final Builder booleanQueryParam(Boolean booleanQueryParam) {
            this.booleanQueryParam = booleanQueryParam;
            return this;
        }

        public final void setBooleanQueryParam(Boolean booleanQueryParam) {
            this.booleanQueryParam = booleanQueryParam;
        }

        public final Integer getIntegerQueryParam() {
            return integerQueryParam;
        }

        @Override
        public final Builder integerQueryParam(Integer integerQueryParam) {
            this.integerQueryParam = integerQueryParam;
            return this;
        }

        public final void setIntegerQueryParam(Integer integerQueryParam) {
            this.integerQueryParam = integerQueryParam;
        }

        public final Long getLongQueryParam() {
            return longQueryParam;
        }

        @Override
        public final Builder longQueryParam(Long longQueryParam) {
            this.longQueryParam = longQueryParam;
            return this;
        }

        public final void setLongQueryParam(Long longQueryParam) {
            this.longQueryParam = longQueryParam;
        }

        public final Float getFloatQueryParam() {
            return floatQueryParam;
        }

        @Override
        public final Builder floatQueryParam(Float floatQueryParam) {
            this.floatQueryParam = floatQueryParam;
            return this;
        }

        public final void setFloatQueryParam(Float floatQueryParam) {
            this.floatQueryParam = floatQueryParam;
        }

        public final Double getDoubleQueryParam() {
            return doubleQueryParam;
        }

        @Override
        public final Builder doubleQueryParam(Double doubleQueryParam) {
            this.doubleQueryParam = doubleQueryParam;
            return this;
        }

        public final void setDoubleQueryParam(Double doubleQueryParam) {
            this.doubleQueryParam = doubleQueryParam;
        }

        public final Instant getTimestampQueryParam() {
            return timestampQueryParam;
        }

        @Override
        public final Builder timestampQueryParam(Instant timestampQueryParam) {
            this.timestampQueryParam = timestampQueryParam;
            return this;
        }

        public final void setTimestampQueryParam(Instant timestampQueryParam) {
            this.timestampQueryParam = timestampQueryParam;
        }

        public final Collection<String> getListOfStrings() {
            return listOfStrings;
        }

        @Override
        public final Builder listOfStrings(Collection<String> listOfStrings) {
            this.listOfStrings = ListOfStringsCopier.copy(listOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfStrings(String... listOfStrings) {
            listOfStrings(Arrays.asList(listOfStrings));
            return this;
        }

        public final void setListOfStrings(Collection<String> listOfStrings) {
            this.listOfStrings = ListOfStringsCopier.copy(listOfStrings);
        }

        @SafeVarargs
        public final void setListOfStrings(String... listOfStrings) {
            listOfStrings(Arrays.asList(listOfStrings));
        }

        public final Map<String, String> getMapOfStringToString() {
            return mapOfStringToString;
        }

        @Override
        public final Builder mapOfStringToString(Map<String, String> mapOfStringToString) {
            this.mapOfStringToString = MapOfStringToStringCopier.copy(mapOfStringToString);
            return this;
        }

        public final void setMapOfStringToString(Map<String, String> mapOfStringToString) {
            this.mapOfStringToString = MapOfStringToStringCopier.copy(mapOfStringToString);
        }

        @Override
        public MembersInQueryParamsRequest build() {
            return new MembersInQueryParamsRequest(this);
        }
    }
}
