/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import org.w3c.dom.Node;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.http.StaxResponseHandler;
import software.amazon.awssdk.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.protocolquery.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolquery.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolquery.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolquery.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolquery.model.ProtocolQueryException;
import software.amazon.awssdk.services.protocolquery.model.QueryTypesRequest;
import software.amazon.awssdk.services.protocolquery.model.QueryTypesResponse;
import software.amazon.awssdk.services.protocolquery.transform.AllTypesRequestMarshaller;
import software.amazon.awssdk.services.protocolquery.transform.AllTypesResponseUnmarshaller;
import software.amazon.awssdk.services.protocolquery.transform.EmptyModeledExceptionUnmarshaller;
import software.amazon.awssdk.services.protocolquery.transform.IdempotentOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolquery.transform.IdempotentOperationResponseUnmarshaller;
import software.amazon.awssdk.services.protocolquery.transform.QueryTypesRequestMarshaller;
import software.amazon.awssdk.services.protocolquery.transform.QueryTypesResponseUnmarshaller;

/**
 * Internal implementation of {@link ProtocolQueryAsyncClient}.
 *
 * @see ProtocolQueryAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultProtocolQueryAsyncClient implements ProtocolQueryAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;

    protected DefaultProtocolQueryAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams)
                .withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.exceptionUnmarshallers = init();
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     * 
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>ProtocolQueryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample ProtocolQueryAsyncClient.AllTypes
     */
    @Override
    public CompletableFuture<AllTypesResponse> allTypes() {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     * 
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>ProtocolQueryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample ProtocolQueryAsyncClient.AllTypes
     */
    @Override
    public CompletableFuture<AllTypesResponse> allTypes(AllTypesRequest allTypesRequest) {

        StaxResponseHandler<AllTypesResponse> responseHandler = new StaxResponseHandler<AllTypesResponse>(
                new AllTypesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AllTypesRequest, AllTypesResponse>()
                .withMarshaller(new AllTypesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(allTypesRequest));
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.
     * 
     * @param idempotentOperationRequest
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.
     * @sample ProtocolQueryAsyncClient.IdempotentOperation
     */
    @Override
    public CompletableFuture<IdempotentOperationResponse> idempotentOperation() {
        return idempotentOperation(IdempotentOperationRequest.builder().build());
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.
     * 
     * @param idempotentOperationRequest
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.
     * @sample ProtocolQueryAsyncClient.IdempotentOperation
     */
    @Override
    public CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            IdempotentOperationRequest idempotentOperationRequest) {

        StaxResponseHandler<IdempotentOperationResponse> responseHandler = new StaxResponseHandler<IdempotentOperationResponse>(
                new IdempotentOperationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<IdempotentOperationRequest, IdempotentOperationResponse>()
                .withMarshaller(new IdempotentOperationRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(idempotentOperationRequest));
    }

    /**
     * Invokes the QueryTypes operation asynchronously.
     * 
     * @param queryTypesRequest
     * @return A Java Future containing the result of the QueryTypes operation returned by the service.
     * @sample ProtocolQueryAsyncClient.QueryTypes
     */
    @Override
    public CompletableFuture<QueryTypesResponse> queryTypes() {
        return queryTypes(QueryTypesRequest.builder().build());
    }

    /**
     * Invokes the QueryTypes operation asynchronously.
     * 
     * @param queryTypesRequest
     * @return A Java Future containing the result of the QueryTypes operation returned by the service.
     * @sample ProtocolQueryAsyncClient.QueryTypes
     */
    @Override
    public CompletableFuture<QueryTypesResponse> queryTypes(QueryTypesRequest queryTypesRequest) {

        StaxResponseHandler<QueryTypesResponse> responseHandler = new StaxResponseHandler<QueryTypesResponse>(
                new QueryTypesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<QueryTypesRequest, QueryTypesResponse>()
                .withMarshaller(new QueryTypesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(queryTypesRequest));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }

    private List<Unmarshaller<AmazonServiceException, Node>> init() {
        List<Unmarshaller<AmazonServiceException, Node>> unmarshallers = new ArrayList<>();
        unmarshallers.add(new EmptyModeledExceptionUnmarshaller());
        unmarshallers.add(new StandardErrorUnmarshaller(ProtocolQueryException.class));
        return unmarshallers;
    }
}
