/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutScalarsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutScalarsRequest.Builder, PutScalarsRequest> {
    private final ScalarsModel scalarsModel;

    private PutScalarsRequest(BuilderImpl builder) {
        this.scalarsModel = builder.scalarsModel;
    }

    /**
     * Returns the value of the ScalarsModel property for this object.
     * 
     * @return The value of the ScalarsModel property for this object.
     */
    public ScalarsModel scalarsModel() {
        return scalarsModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((scalarsModel() == null) ? 0 : scalarsModel().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalarsRequest)) {
            return false;
        }
        PutScalarsRequest other = (PutScalarsRequest) obj;
        if (other.scalarsModel() == null ^ this.scalarsModel() == null) {
            return false;
        }
        if (other.scalarsModel() != null && !other.scalarsModel().equals(this.scalarsModel())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (scalarsModel() != null) {
            sb.append("ScalarsModel: ").append(scalarsModel()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutScalarsRequest> {
        /**
         * Sets the value of the ScalarsModel property for this object.
         *
         * @param scalarsModel
         *        The new value for the ScalarsModel property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalarsModel(ScalarsModel scalarsModel);
    }

    private static final class BuilderImpl implements Builder {
        private ScalarsModel scalarsModel;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalarsRequest model) {
            setScalarsModel(model.scalarsModel);
        }

        public final ScalarsModel getScalarsModel() {
            return scalarsModel;
        }

        @Override
        public final Builder scalarsModel(ScalarsModel scalarsModel) {
            this.scalarsModel = scalarsModel;
            return this;
        }

        public final void setScalarsModel(ScalarsModel scalarsModel) {
            this.scalarsModel = scalarsModel;
        }

        @Override
        public PutScalarsRequest build() {
            return new PutScalarsRequest(this);
        }
    }
}
