/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol;

import javax.annotation.Generated;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.AllTypesRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.AllTypesResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.ApiGatewayProtocolException;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.GetScalarsRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.GetScalarsResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MembersInHeadersRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MembersInHeadersResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MultiLocationOperationRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MultiLocationOperationResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MultiPathParamOperationRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.MultiPathParamOperationResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.NoModeledExceptionsRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.NoModeledExceptionsResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.PutScalarsRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.PutScalarsResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SameShapeDifferentStatusCodesRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SameShapeDifferentStatusCodesResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponse;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.SomeModeledException;
import software.amazon.awssdk.regions.ServiceMetadata;

/**
 * Service client for accessing ApiGatewayProtocol. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ApiGatewayProtocolClient extends AutoCloseable {
    String SERVICE_NAME = "7pa86qnoj3.execute-api";

    /**
     * Create a {@link ApiGatewayProtocolClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static ApiGatewayProtocolClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApiGatewayProtocolClient}.
     */
    static ApiGatewayProtocolClientBuilder builder() {
        return new DefaultApiGatewayProtocolClientBuilder();
    }

    /**
     * Invokes the AllTypes operation.
     * 
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @sample ApiGatewayProtocolClient.AllTypes
     */
    default AllTypesResponse allTypes() throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation.
     * 
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @sample ApiGatewayProtocolClient.AllTypes
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the GetScalars operation.
     * 
     * @param getScalarsRequest
     * @return Result of the GetScalars operation returned by the service.
     * @sample ApiGatewayProtocolClient.GetScalars
     */
    default GetScalarsResponse getScalars() throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the GetScalars operation.
     * 
     * @param getScalarsRequest
     * @return Result of the GetScalars operation returned by the service.
     * @sample ApiGatewayProtocolClient.GetScalars
     */
    default GetScalarsResponse getScalars(GetScalarsRequest getScalarsRequest) throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInHeaders operation.
     * 
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @sample ApiGatewayProtocolClient.MembersInHeaders
     */
    default MembersInHeadersResponse membersInHeaders() throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInHeaders operation.
     * 
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @sample ApiGatewayProtocolClient.MembersInHeaders
     */
    default MembersInHeadersResponse membersInHeaders(MembersInHeadersRequest membersInHeadersRequest) throws SdkBaseException,
            SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiLocationOperation operation.
     * 
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @sample ApiGatewayProtocolClient.MultiLocationOperation
     */
    default MultiLocationOperationResponse multiLocationOperation() throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiLocationOperation operation.
     * 
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @sample ApiGatewayProtocolClient.MultiLocationOperation
     */
    default MultiLocationOperationResponse multiLocationOperation(MultiLocationOperationRequest multiLocationOperationRequest)
            throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiPathParamOperation operation.
     * 
     * @param multiPathParamOperationRequest
     * @return Result of the MultiPathParamOperation operation returned by the service.
     * @sample ApiGatewayProtocolClient.MultiPathParamOperation
     */
    default MultiPathParamOperationResponse multiPathParamOperation() throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiPathParamOperation operation.
     * 
     * @param multiPathParamOperationRequest
     * @return Result of the MultiPathParamOperation operation returned by the service.
     * @sample ApiGatewayProtocolClient.MultiPathParamOperation
     */
    default MultiPathParamOperationResponse multiPathParamOperation(MultiPathParamOperationRequest multiPathParamOperationRequest)
            throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the NoModeledExceptions operation.
     * 
     * @param noModeledExceptionsRequest
     * @return Result of the NoModeledExceptions operation returned by the service.
     * @sample ApiGatewayProtocolClient.NoModeledExceptions
     */
    default NoModeledExceptionsResponse noModeledExceptions() throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the NoModeledExceptions operation.
     * 
     * @param noModeledExceptionsRequest
     * @return Result of the NoModeledExceptions operation returned by the service.
     * @sample ApiGatewayProtocolClient.NoModeledExceptions
     */
    default NoModeledExceptionsResponse noModeledExceptions(NoModeledExceptionsRequest noModeledExceptionsRequest)
            throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     * 
     * @param operationWithNoInputOrOutputRequest
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @sample ApiGatewayProtocolClient.OperationWithNoInputOrOutput
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput() throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     * 
     * @param operationWithNoInputOrOutputRequest
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @sample ApiGatewayProtocolClient.OperationWithNoInputOrOutput
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the PutScalars operation.
     * 
     * @param putScalarsRequest
     * @return Result of the PutScalars operation returned by the service.
     * @sample ApiGatewayProtocolClient.PutScalars
     */
    default PutScalarsResponse putScalars() throws SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the PutScalars operation.
     * 
     * @param putScalarsRequest
     * @return Result of the PutScalars operation returned by the service.
     * @sample ApiGatewayProtocolClient.PutScalars
     */
    default PutScalarsResponse putScalars(PutScalarsRequest putScalarsRequest) throws SdkBaseException, SdkClientException,
            ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the SameShapeDifferentStatusCodes operation.
     * 
     * @param sameShapeDifferentStatusCodesRequest
     * @return Result of the SameShapeDifferentStatusCodes operation returned by the service.
     * @throws SomeModeledException
     * @throws SomeModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ApiGatewayProtocolException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ApiGatewayProtocolClient.SameShapeDifferentStatusCodes
     */
    default SameShapeDifferentStatusCodesResponse sameShapeDifferentStatusCodes() throws SomeModeledException, SdkBaseException,
            SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the SameShapeDifferentStatusCodes operation.
     * 
     * @param sameShapeDifferentStatusCodesRequest
     * @return Result of the SameShapeDifferentStatusCodes operation returned by the service.
     * @throws SomeModeledException
     * @throws SomeModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ApiGatewayProtocolException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ApiGatewayProtocolClient.SameShapeDifferentStatusCodes
     */
    default SameShapeDifferentStatusCodesResponse sameShapeDifferentStatusCodes(
            SameShapeDifferentStatusCodesRequest sameShapeDifferentStatusCodesRequest) throws SomeModeledException,
            SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the SharedExceptionsAcrossOperationsWithDifferentStatusCodes operation.
     * 
     * @param sharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest
     * @return Result of the SharedExceptionsAcrossOperationsWithDifferentStatusCodes operation returned by the service.
     * @throws SomeModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ApiGatewayProtocolException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ApiGatewayProtocolClient.SharedExceptionsAcrossOperationsWithDifferentStatusCodes
     */
    default SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponse sharedExceptionsAcrossOperationsWithDifferentStatusCodes()
            throws SomeModeledException, SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the SharedExceptionsAcrossOperationsWithDifferentStatusCodes operation.
     * 
     * @param sharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest
     * @return Result of the SharedExceptionsAcrossOperationsWithDifferentStatusCodes operation returned by the service.
     * @throws SomeModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ApiGatewayProtocolException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ApiGatewayProtocolClient.SharedExceptionsAcrossOperationsWithDifferentStatusCodes
     */
    default SharedExceptionsAcrossOperationsWithDifferentStatusCodesResponse sharedExceptionsAcrossOperationsWithDifferentStatusCodes(
            SharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest sharedExceptionsAcrossOperationsWithDifferentStatusCodesRequest)
            throws SomeModeledException, SdkBaseException, SdkClientException, ApiGatewayProtocolException {
        throw new UnsupportedOperationException();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("7pa86qnoj3.execute-api");
    }
}
