/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocoljsonrpc;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.protocoljsonrpc.model.AllTypesRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.AllTypesResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.FurtherNestedContainersRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.FurtherNestedContainersResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.NestedContainersRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.NestedContainersResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.OperationWithNoInputOrOutputResponse;

/**
 * Service client for accessing JsonProtocolTests asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolJsonRpcAsyncClient extends SdkClient {
    String SERVICE_NAME = "jsonrpc";

    /**
     * Create a {@link ProtocolJsonRpcAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ProtocolJsonRpcAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolJsonRpcAsyncClient}.
     */
    static ProtocolJsonRpcAsyncClientBuilder builder() {
        return new DefaultProtocolJsonRpcAsyncClientBuilder();
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     *
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>ImplicitPayloadException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllTypesResponse> allTypes(AllTypesRequest allTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllTypesRequest.Builder} avoiding the need to
     * create one manually via {@link AllTypesRequest#builder()}
     * </p>
     *
     * @param allTypesRequest
     *        A {@link Consumer} that will call methods on {@link AllTypesStructure.Builder} to create a request.
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>ImplicitPayloadException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllTypesResponse> allTypes(Consumer<AllTypesRequest.Builder> allTypesRequest) {
        return allTypes(AllTypesRequest.builder().applyMutation(allTypesRequest).build());
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     *
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>ImplicitPayloadException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllTypesResponse> allTypes() {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the FurtherNestedContainers operation asynchronously.
     *
     * @param furtherNestedContainersRequest
     * @return A Java Future containing the result of the FurtherNestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.FurtherNestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/FurtherNestedContainers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<FurtherNestedContainersResponse> furtherNestedContainers(
            FurtherNestedContainersRequest furtherNestedContainersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the FurtherNestedContainers operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FurtherNestedContainersRequest.Builder} avoiding
     * the need to create one manually via {@link FurtherNestedContainersRequest#builder()}
     * </p>
     *
     * @param furtherNestedContainersRequest
     *        A {@link Consumer} that will call methods on {@link FurtherNestedContainersStructure.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the FurtherNestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.FurtherNestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/FurtherNestedContainers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<FurtherNestedContainersResponse> furtherNestedContainers(
            Consumer<FurtherNestedContainersRequest.Builder> furtherNestedContainersRequest) {
        return furtherNestedContainers(FurtherNestedContainersRequest.builder().applyMutation(furtherNestedContainersRequest)
                .build());
    }

    /**
     * Invokes the FurtherNestedContainers operation asynchronously.
     *
     * @return A Java Future containing the result of the FurtherNestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.FurtherNestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/FurtherNestedContainers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<FurtherNestedContainersResponse> furtherNestedContainers() {
        return furtherNestedContainers(FurtherNestedContainersRequest.builder().build());
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.
     *
     * @param idempotentOperationRequest
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            IdempotentOperationRequest idempotentOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IdempotentOperationRequest.Builder} avoiding the
     * need to create one manually via {@link IdempotentOperationRequest#builder()}
     * </p>
     *
     * @param idempotentOperationRequest
     *        A {@link Consumer} that will call methods on {@link IdempotentOperationStructure.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            Consumer<IdempotentOperationRequest.Builder> idempotentOperationRequest) {
        return idempotentOperation(IdempotentOperationRequest.builder().applyMutation(idempotentOperationRequest).build());
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.
     *
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<IdempotentOperationResponse> idempotentOperation() {
        return idempotentOperation(IdempotentOperationRequest.builder().build());
    }

    /**
     * Invokes the NestedContainers operation asynchronously.
     *
     * @param nestedContainersRequest
     * @return A Java Future containing the result of the NestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<NestedContainersResponse> nestedContainers(NestedContainersRequest nestedContainersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the NestedContainers operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NestedContainersRequest.Builder} avoiding the need
     * to create one manually via {@link NestedContainersRequest#builder()}
     * </p>
     *
     * @param nestedContainersRequest
     *        A {@link Consumer} that will call methods on {@link NestedContainersStructure.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the NestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<NestedContainersResponse> nestedContainers(
            Consumer<NestedContainersRequest.Builder> nestedContainersRequest) {
        return nestedContainers(NestedContainersRequest.builder().applyMutation(nestedContainersRequest).build());
    }

    /**
     * Invokes the NestedContainers operation asynchronously.
     *
     * @return A Java Future containing the result of the NestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<NestedContainersResponse> nestedContainers() {
        return nestedContainers(NestedContainersRequest.builder().build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation asynchronously.
     *
     * @param operationWithNoInputOrOutputRequest
     * @return A Java Future containing the result of the OperationWithNoInputOrOutput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithNoInputOrOutputResponse> operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithNoInputOrOutputRequest.Builder}
     * avoiding the need to create one manually via {@link OperationWithNoInputOrOutputRequest#builder()}
     * </p>
     *
     * @param operationWithNoInputOrOutputRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithNoInputOrOutputRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the OperationWithNoInputOrOutput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithNoInputOrOutputResponse> operationWithNoInputOrOutput(
            Consumer<OperationWithNoInputOrOutputRequest.Builder> operationWithNoInputOrOutputRequest) {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder()
                .applyMutation(operationWithNoInputOrOutputRequest).build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation asynchronously.
     *
     * @return A Java Future containing the result of the OperationWithNoInputOrOutput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolJsonRpcException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolJsonRpcAsyncClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithNoInputOrOutputResponse> operationWithNoInputOrOutput() {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder().build());
    }
}
