/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.transform;

import static software.amazon.awssdk.core.util.StringUtils.UTF8;

import java.io.StringWriter;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolrestxml.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;

import software.amazon.awssdk.core.util.XmlWriter;

/**
 * MultiLocationOperationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MultiLocationOperationRequestMarshaller implements
        Marshaller<Request<MultiLocationOperationRequest>, MultiLocationOperationRequest> {

    public Request<MultiLocationOperationRequest> marshall(MultiLocationOperationRequest multiLocationOperationRequest) {

        if (multiLocationOperationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<MultiLocationOperationRequest> request = new DefaultRequest<MultiLocationOperationRequest>(
                multiLocationOperationRequest, "ProtocolRestXmlClient");

        request.setHttpMethod(HttpMethodName.POST);

        if (multiLocationOperationRequest.stringHeaderMember() != null) {
            request.addHeader("x-amz-header-string", StringUtils.fromString(multiLocationOperationRequest.stringHeaderMember()));
        }

        if (multiLocationOperationRequest.timestampHeaderMember() != null) {
            request.addHeader("x-amz-timearg", StringUtils.fromInstant(multiLocationOperationRequest.timestampHeaderMember()));
        }

        String uriResourcePath = "/2016-03-11/multiLocationOperation/{PathParam}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "PathParam", multiLocationOperationRequest.pathParam());
        request.setResourcePath(uriResourcePath);

        if (multiLocationOperationRequest.queryParamOne() != null) {
            request.addParameter("QueryParamOne", StringUtils.fromString(multiLocationOperationRequest.queryParamOne()));
        }

        if (multiLocationOperationRequest.queryParamTwo() != null) {
            request.addParameter("QueryParamTwo", StringUtils.fromString(multiLocationOperationRequest.queryParamTwo()));
        }

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://restxml/");

            xmlWriter.startElement("MultiLocationOperationRequest");

            PayloadStructType payloadStructParam = multiLocationOperationRequest.payloadStructParam();
            if (payloadStructParam != null) {
                xmlWriter.startElement("PayloadStructParam");

                if (payloadStructParam.payloadMemberOne() != null) {
                    xmlWriter.startElement("PayloadMemberOne").value(payloadStructParam.payloadMemberOne()).endElement();
                }

                if (payloadStructParam.payloadMemberTwo() != null) {
                    xmlWriter.startElement("PayloadMemberTwo").value(payloadStructParam.payloadMemberTwo()).endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}