/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocoljsonrpc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class NestedContainersResponse extends ProtocolJsonRpcResponse implements
        ToCopyableBuilder<NestedContainersResponse.Builder, NestedContainersResponse> {
    private final List<List<String>> listOfListsOfStrings;

    private final List<List<List<String>>> listOfListOfListsOfStrings;

    private final Map<String, List<List<String>>> mapOfStringToListOfListsOfStrings;

    private NestedContainersResponse(BuilderImpl builder) {
        super(builder);
        this.listOfListsOfStrings = builder.listOfListsOfStrings;
        this.listOfListOfListsOfStrings = builder.listOfListOfListsOfStrings;
        this.mapOfStringToListOfListsOfStrings = builder.mapOfStringToListOfListsOfStrings;
    }

    /**
     * Returns the value of the ListOfListsOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListOfListsOfStrings property for this object.
     */
    public List<List<String>> listOfListsOfStrings() {
        return listOfListsOfStrings;
    }

    /**
     * Returns the value of the ListOfListOfListsOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListOfListOfListsOfStrings property for this object.
     */
    public List<List<List<String>>> listOfListOfListsOfStrings() {
        return listOfListOfListsOfStrings;
    }

    /**
     * Returns the value of the MapOfStringToListOfListsOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the MapOfStringToListOfListsOfStrings property for this object.
     */
    public Map<String, List<List<String>>> mapOfStringToListOfListsOfStrings() {
        return mapOfStringToListOfListsOfStrings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listOfListsOfStrings());
        hashCode = 31 * hashCode + Objects.hashCode(listOfListOfListsOfStrings());
        hashCode = 31 * hashCode + Objects.hashCode(mapOfStringToListOfListsOfStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NestedContainersResponse)) {
            return false;
        }
        NestedContainersResponse other = (NestedContainersResponse) obj;
        return Objects.equals(listOfListsOfStrings(), other.listOfListsOfStrings())
                && Objects.equals(listOfListOfListsOfStrings(), other.listOfListOfListsOfStrings())
                && Objects.equals(mapOfStringToListOfListsOfStrings(), other.mapOfStringToListOfListsOfStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("NestedContainersResponse").add("ListOfListsOfStrings", listOfListsOfStrings())
                .add("ListOfListOfListsOfStrings", listOfListOfListsOfStrings())
                .add("MapOfStringToListOfListsOfStrings", mapOfStringToListOfListsOfStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListOfListsOfStrings":
            return Optional.of(clazz.cast(listOfListsOfStrings()));
        case "ListOfListOfListsOfStrings":
            return Optional.of(clazz.cast(listOfListOfListsOfStrings()));
        case "MapOfStringToListOfListsOfStrings":
            return Optional.of(clazz.cast(mapOfStringToListOfListsOfStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolJsonRpcResponse.Builder, CopyableBuilder<Builder, NestedContainersResponse> {
        /**
         * Sets the value of the ListOfListsOfStrings property for this object.
         *
         * @param listOfListsOfStrings
         *        The new value for the ListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListsOfStrings(Collection<? extends Collection<String>> listOfListsOfStrings);

        /**
         * Sets the value of the ListOfListsOfStrings property for this object.
         *
         * @param listOfListsOfStrings
         *        The new value for the ListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListsOfStrings(Collection<String>... listOfListsOfStrings);

        /**
         * Sets the value of the ListOfListOfListsOfStrings property for this object.
         *
         * @param listOfListOfListsOfStrings
         *        The new value for the ListOfListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListOfListsOfStrings(
                Collection<? extends Collection<? extends Collection<String>>> listOfListOfListsOfStrings);

        /**
         * Sets the value of the ListOfListOfListsOfStrings property for this object.
         *
         * @param listOfListOfListsOfStrings
         *        The new value for the ListOfListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListOfListsOfStrings(Collection<? extends Collection<String>>... listOfListOfListsOfStrings);

        /**
         * Sets the value of the MapOfStringToListOfListsOfStrings property for this object.
         *
         * @param mapOfStringToListOfListsOfStrings
         *        The new value for the MapOfStringToListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapOfStringToListOfListsOfStrings(
                Map<String, ? extends Collection<? extends Collection<String>>> mapOfStringToListOfListsOfStrings);
    }

    static final class BuilderImpl extends ProtocolJsonRpcResponse.BuilderImpl implements Builder {
        private List<List<String>> listOfListsOfStrings;

        private List<List<List<String>>> listOfListOfListsOfStrings;

        private Map<String, List<List<String>>> mapOfStringToListOfListsOfStrings;

        private BuilderImpl() {
        }

        private BuilderImpl(NestedContainersResponse model) {
            super(model);
            listOfListsOfStrings(model.listOfListsOfStrings);
            listOfListOfListsOfStrings(model.listOfListOfListsOfStrings);
            mapOfStringToListOfListsOfStrings(model.mapOfStringToListOfListsOfStrings);
        }

        public final Collection<? extends Collection<String>> getListOfListsOfStrings() {
            return listOfListsOfStrings;
        }

        @Override
        public final Builder listOfListsOfStrings(Collection<? extends Collection<String>> listOfListsOfStrings) {
            this.listOfListsOfStrings = ListOfListsOfStringsCopier.copy(listOfListsOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfListsOfStrings(Collection<String>... listOfListsOfStrings) {
            listOfListsOfStrings(Arrays.asList(listOfListsOfStrings));
            return this;
        }

        public final void setListOfListsOfStrings(Collection<? extends Collection<String>> listOfListsOfStrings) {
            this.listOfListsOfStrings = ListOfListsOfStringsCopier.copy(listOfListsOfStrings);
        }

        public final Collection<? extends Collection<? extends Collection<String>>> getListOfListOfListsOfStrings() {
            return listOfListOfListsOfStrings;
        }

        @Override
        public final Builder listOfListOfListsOfStrings(
                Collection<? extends Collection<? extends Collection<String>>> listOfListOfListsOfStrings) {
            this.listOfListOfListsOfStrings = ListOfListOfListsOfStringsCopier.copy(listOfListOfListsOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfListOfListsOfStrings(Collection<? extends Collection<String>>... listOfListOfListsOfStrings) {
            listOfListOfListsOfStrings(Arrays.asList(listOfListOfListsOfStrings));
            return this;
        }

        public final void setListOfListOfListsOfStrings(
                Collection<? extends Collection<? extends Collection<String>>> listOfListOfListsOfStrings) {
            this.listOfListOfListsOfStrings = ListOfListOfListsOfStringsCopier.copy(listOfListOfListsOfStrings);
        }

        public final Map<String, ? extends Collection<? extends Collection<String>>> getMapOfStringToListOfListsOfStrings() {
            return mapOfStringToListOfListsOfStrings;
        }

        @Override
        public final Builder mapOfStringToListOfListsOfStrings(
                Map<String, ? extends Collection<? extends Collection<String>>> mapOfStringToListOfListsOfStrings) {
            this.mapOfStringToListOfListsOfStrings = MapOfStringToListOfListsOfStringsCopier
                    .copy(mapOfStringToListOfListsOfStrings);
            return this;
        }

        public final void setMapOfStringToListOfListsOfStrings(
                Map<String, ? extends Collection<? extends Collection<String>>> mapOfStringToListOfListsOfStrings) {
            this.mapOfStringToListOfListsOfStrings = MapOfStringToListOfListsOfStringsCopier
                    .copy(mapOfStringToListOfListsOfStrings);
        }

        @Override
        public NestedContainersResponse build() {
            return new NestedContainersResponse(this);
        }
    }
}
