/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IdempotentOperationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<IdempotentOperationResponse.Builder, IdempotentOperationResponse> {
    private final String idempotencyToken;

    private IdempotentOperationResponse(BuilderImpl builder) {
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     *
     * @return
     */
    public String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((idempotencyToken() == null) ? 0 : idempotencyToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdempotentOperationResponse)) {
            return false;
        }
        IdempotentOperationResponse other = (IdempotentOperationResponse) obj;
        if (other.idempotencyToken() == null ^ this.idempotencyToken() == null) {
            return false;
        }
        if (other.idempotencyToken() != null && !other.idempotencyToken().equals(this.idempotencyToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (idempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(idempotencyToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IdempotentOperationResponse> {
        /**
         *
         * @param idempotencyToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);
    }

    private static final class BuilderImpl implements Builder {
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(IdempotentOperationResponse model) {
            setIdempotencyToken(model.idempotencyToken);
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public IdempotentOperationResponse build() {
            return new IdempotentOperationResponse(this);
        }
    }
}
