/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.services.protocolquery.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolquery.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolquery.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolquery.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolquery.model.QueryTypesRequest;
import software.amazon.awssdk.services.protocolquery.model.QueryTypesResponse;

/**
 * Service client for accessing AmazonProtocolQuery asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolQueryAsyncClient extends AutoCloseable {
    /**
     * Create a {@link ProtocolQueryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static ProtocolQueryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolQueryAsyncClient}.
     */
    static ProtocolQueryAsyncClientBuilder builder() {
        return new DefaultProtocolQueryAsyncClientBuilder();
    }

    /**
     *
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>ProtocolQueryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample ProtocolQueryAsyncClient.AllTypes
     */
    default CompletableFuture<AllTypesResponse> allTypes(AllTypesRequest allTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * @param idempotentOperationRequest
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.
     * @sample ProtocolQueryAsyncClient.IdempotentOperation
     */
    default CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            IdempotentOperationRequest idempotentOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * @param queryTypesRequest
     * @return A Java Future containing the result of the QueryTypes operation returned by the service.
     * @sample ProtocolQueryAsyncClient.QueryTypes
     */
    default CompletableFuture<QueryTypesResponse> queryTypes(QueryTypesRequest queryTypesRequest) {
        throw new UnsupportedOperationException();
    }
}
