/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model;

import javax.annotation.Generated;
import software.amazon.awssdk.opensdk.BaseResult;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MembersInHeadersResponse extends BaseResult implements
        ToCopyableBuilder<MembersInHeadersResponse.Builder, MembersInHeadersResponse> {
    private final AllTypesStructure payloadMember;

    private final String headerMemberOne;

    private final String headerMemberTwo;

    private MembersInHeadersResponse(BuilderImpl builder) {
        this.payloadMember = builder.payloadMember;
        this.headerMemberOne = builder.headerMemberOne;
        this.headerMemberTwo = builder.headerMemberTwo;
    }

    /**
     *
     * @return
     */
    public AllTypesStructure payloadMember() {
        return payloadMember;
    }

    /**
     *
     * @return
     */
    public String headerMemberOne() {
        return headerMemberOne;
    }

    /**
     *
     * @return
     */
    public String headerMemberTwo() {
        return headerMemberTwo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((payloadMember() == null) ? 0 : payloadMember().hashCode());
        hashCode = 31 * hashCode + ((headerMemberOne() == null) ? 0 : headerMemberOne().hashCode());
        hashCode = 31 * hashCode + ((headerMemberTwo() == null) ? 0 : headerMemberTwo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembersInHeadersResponse)) {
            return false;
        }
        MembersInHeadersResponse other = (MembersInHeadersResponse) obj;
        if (other.payloadMember() == null ^ this.payloadMember() == null) {
            return false;
        }
        if (other.payloadMember() != null && !other.payloadMember().equals(this.payloadMember())) {
            return false;
        }
        if (other.headerMemberOne() == null ^ this.headerMemberOne() == null) {
            return false;
        }
        if (other.headerMemberOne() != null && !other.headerMemberOne().equals(this.headerMemberOne())) {
            return false;
        }
        if (other.headerMemberTwo() == null ^ this.headerMemberTwo() == null) {
            return false;
        }
        if (other.headerMemberTwo() != null && !other.headerMemberTwo().equals(this.headerMemberTwo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (payloadMember() != null) {
            sb.append("PayloadMember: ").append(payloadMember()).append(",");
        }
        if (headerMemberOne() != null) {
            sb.append("HeaderMemberOne: ").append(headerMemberOne()).append(",");
        }
        if (headerMemberTwo() != null) {
            sb.append("HeaderMemberTwo: ").append(headerMemberTwo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MembersInHeadersResponse> {
        /**
         *
         * @param payloadMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMember(AllTypesStructure payloadMember);

        /**
         *
         * @param headerMemberOne
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerMemberOne(String headerMemberOne);

        /**
         *
         * @param headerMemberTwo
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerMemberTwo(String headerMemberTwo);
    }

    private static final class BuilderImpl implements Builder {
        private AllTypesStructure payloadMember;

        private String headerMemberOne;

        private String headerMemberTwo;

        private BuilderImpl() {
        }

        private BuilderImpl(MembersInHeadersResponse model) {
            setPayloadMember(model.payloadMember);
            setHeaderMemberOne(model.headerMemberOne);
            setHeaderMemberTwo(model.headerMemberTwo);
        }

        public final AllTypesStructure getPayloadMember() {
            return payloadMember;
        }

        @Override
        public final Builder payloadMember(AllTypesStructure payloadMember) {
            this.payloadMember = payloadMember;
            return this;
        }

        public final void setPayloadMember(AllTypesStructure payloadMember) {
            this.payloadMember = payloadMember;
        }

        public final String getHeaderMemberOne() {
            return headerMemberOne;
        }

        @Override
        public final Builder headerMemberOne(String headerMemberOne) {
            this.headerMemberOne = headerMemberOne;
            return this;
        }

        public final void setHeaderMemberOne(String headerMemberOne) {
            this.headerMemberOne = headerMemberOne;
        }

        public final String getHeaderMemberTwo() {
            return headerMemberTwo;
        }

        @Override
        public final Builder headerMemberTwo(String headerMemberTwo) {
            this.headerMemberTwo = headerMemberTwo;
            return this;
        }

        public final void setHeaderMemberTwo(String headerMemberTwo) {
            this.headerMemberTwo = headerMemberTwo;
        }

        @Override
        public MembersInHeadersResponse build() {
            return new MembersInHeadersResponse(this);
        }
    }
}
