/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.stream.Stream;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.protocol.model.TestCase;
import software.amazon.awssdk.protocol.wiremock.WireMockUtils;
import software.amazon.awssdk.regions.Region;

public class ClientReflector {
    private final IntermediateModel model;
    private final Metadata metadata;
    private final Object client;
    private final Class<?> interfaceClass;

    public ClientReflector(IntermediateModel model) {
        this.model = model;
        this.metadata = model.getMetadata();
        this.interfaceClass = this.getInterfaceClass();
        this.client = this.createClient();
    }

    private Class<?> getInterfaceClass() {
        try {
            return Class.forName(this.getClientFqcn(this.metadata.getSyncInterface()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object invokeMethod(TestCase testCase, Object ... params) throws Exception {
        String operationName = testCase.getWhen().getOperationName();
        Method operationMethod = this.getOperationMethod(operationName, params);
        return operationMethod.invoke(this.client, params);
    }

    public Object invokeStreamingMethod(TestCase testCase, Object requestObject, ResponseTransformer<?, ?> responseHandler) throws Exception {
        String operationName = testCase.getWhen().getOperationName();
        Method operationMethod = this.getOperationMethod(operationName, requestObject.getClass(), ResponseTransformer.class);
        return operationMethod.invoke(this.client, requestObject, responseHandler);
    }

    private Object createClient() {
        try {
            Object untypedBuilder = this.interfaceClass.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
            AwsClientBuilder builder = (AwsClientBuilder)untypedBuilder;
            return ((AwsClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)this.getMockCredentials()).region(Region.US_EAST_1).endpointOverride(URI.create(this.getEndpoint()))).build();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private String getEndpoint() {
        return "http://localhost:" + WireMockUtils.port();
    }

    private StaticCredentialsProvider getMockCredentials() {
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"akid", (String)"skid"));
    }

    private String getClientFqcn(String simpleClassName) {
        return String.format("%s.%s", this.metadata.getFullClientPackageName(), simpleClassName);
    }

    private Method getOperationMethod(String operationName, Object ... params) throws Exception {
        Class[] classes = (Class[])Stream.of(params).map(Object::getClass).toArray(Class[]::new);
        return this.getOperationMethod(operationName, classes);
    }

    private Method getOperationMethod(String operationName, Class<?> ... classes) throws Exception {
        return this.interfaceClass.getMethod(this.getOperationMethodName(operationName), classes);
    }

    private String getOperationMethodName(String operationName) {
        return ((OperationModel)this.model.getOperations().get(operationName)).getMethodName();
    }
}

