/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.asserts.marshalling;

import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.net.URI;
import org.junit.Assert;
import software.amazon.awssdk.protocol.asserts.marshalling.MarshallingAssertion;

public class UriAssertion
extends MarshallingAssertion {
    private final String expectedUri;

    public UriAssertion(String uri) {
        this.expectedUri = uri;
    }

    @Override
    protected void doAssert(LoggedRequest actual) throws Exception {
        Assert.assertEquals((Object)this.removeTrailingSlash(this.expectedUri), (Object)this.removeTrailingSlash(this.getActualPath(actual)));
    }

    private String getActualPath(LoggedRequest actual) {
        return URI.create(actual.getUrl()).getPath();
    }

    private String removeTrailingSlash(String str) {
        return str.endsWith("/") ? str.substring(0, str.lastIndexOf("/")) : str;
    }
}

