/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.asserts.marshalling;

import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import software.amazon.awssdk.protocol.asserts.marshalling.MarshallingAssertion;
import software.amazon.awssdk.util.StringUtils;

public class QueryParamsAssertion
extends MarshallingAssertion {
    private Map<String, List<String>> contains;
    private List<String> doesNotContain;

    public void setContains(Map<String, List<String>> contains) {
        this.contains = contains;
    }

    public void setDoesNotContain(List<String> doesNotContain) {
        this.doesNotContain = doesNotContain;
    }

    @Override
    protected void doAssert(LoggedRequest actual) throws Exception {
        try {
            Map<String, List<String>> actualParams = this.parseQueryParams(actual);
            this.doAssert(actualParams);
        }
        catch (AssertionError error) {
            Map<String, List<String>> actualParams = this.parseQueryParamsFromBody(actual.getBodyAsString());
            this.doAssert(actualParams);
        }
    }

    private void doAssert(Map<String, List<String>> actualParams) {
        if (this.contains != null) {
            this.assertContains(actualParams);
        }
        if (this.doesNotContain != null) {
            this.assertDoesNotContain(actualParams);
        }
    }

    private Map<String, List<String>> parseQueryParamsFromBody(String body) {
        return this.toQueryParamMap(URLEncodedUtils.parse((String)body, (Charset)StandardCharsets.UTF_8));
    }

    private Map<String, List<String>> parseQueryParams(LoggedRequest actual) {
        return this.toQueryParamMap(this.parseNameValuePairsFromQuery(actual));
    }

    private Map<String, List<String>> toQueryParamMap(List<NameValuePair> queryParams) {
        return queryParams.stream().collect(Collectors.groupingBy(p -> p.getName(), Collectors.mapping(p -> p.getValue(), Collectors.toList())));
    }

    private List<NameValuePair> parseNameValuePairsFromQuery(LoggedRequest actual) {
        String queryParams = URI.create(actual.getUrl()).getQuery();
        if (StringUtils.isNullOrEmpty((String)queryParams)) {
            return Collections.emptyList();
        }
        return URLEncodedUtils.parse((String)queryParams, (Charset)StandardCharsets.UTF_8);
    }

    private void assertContains(Map<String, List<String>> actualParams) {
        this.contains.entrySet().forEach(e -> Assert.assertThat(actualParams.get(e.getKey()), (Matcher)Matchers.containsInAnyOrder((Object[])((List)e.getValue()).toArray())));
    }

    private void assertDoesNotContain(Map<String, List<String>> actualParams) {
        this.doesNotContain.forEach(key -> Assert.assertThat((Object)actualParams, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)key))));
    }
}

