/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.protocol.model.TestCase;
import software.amazon.awssdk.protocol.model.TestSuite;

public class ProtocolTestSuiteLoader {
    private static final String RESOURCE_PREFIX = "/software/amazon/awssdk/protocol/suites/";
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);

    public List<TestCase> load(String suitePath) throws IOException {
        return this.loadTestSuite(suitePath).getTestCases().stream().flatMap(this::loadTestCases).collect(Collectors.toList());
    }

    private TestSuite loadTestSuite(String suitePath) throws IOException {
        return (TestSuite)MAPPER.readValue(this.getClass().getResource(RESOURCE_PREFIX + suitePath), TestSuite.class);
    }

    private Stream<? extends TestCase> loadTestCases(String testCase) {
        try {
            List testCases = (List)MAPPER.readValue(this.getClass().getResource(RESOURCE_PREFIX + testCase), (TypeReference)new ListTypeReference());
            return testCases.stream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ListTypeReference
    extends TypeReference<List<TestCase>> {
        private ListTypeReference() {
        }
    }
}

