/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.runners;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.protocol.model.TestCase;
import software.amazon.awssdk.protocol.reflect.ClientReflector;
import software.amazon.awssdk.protocol.runners.MarshallingTestRunner;
import software.amazon.awssdk.protocol.runners.UnmarshallingTestRunner;
import software.amazon.awssdk.protocol.wiremock.WireMockUtils;
import software.amazon.awssdk.util.IdempotentUtils;

public class ProtocolTestRunner {
    private static final Logger log = LoggerFactory.getLogger(ProtocolTestRunner.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
    private final ClientReflector clientReflector;
    private final MarshallingTestRunner marshallingTestRunner;
    private final UnmarshallingTestRunner unmarshallingTestRunner;

    public ProtocolTestRunner(String intermediateModelLocation) {
        WireMockUtils.startWireMockServer();
        IntermediateModel model = this.loadModel(intermediateModelLocation);
        this.clientReflector = new ClientReflector(model);
        this.marshallingTestRunner = new MarshallingTestRunner(model, this.clientReflector);
        this.unmarshallingTestRunner = new UnmarshallingTestRunner(model, this.clientReflector);
        IdempotentUtils.setGenerator(() -> "00000000-0000-4000-8000-000000000000");
    }

    private IntermediateModel loadModel(String intermedidateModelLocation) {
        try {
            return (IntermediateModel)MAPPER.readValue(this.getClass().getResource(intermedidateModelLocation), IntermediateModel.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void runTests(List<TestCase> tests) throws Exception {
        block4: for (TestCase testCase : tests) {
            log.info("Running test: {}", (Object)testCase.getDescription());
            switch (testCase.getWhen().getAction()) {
                case MARSHALL: {
                    this.marshallingTestRunner.runTest(testCase);
                    continue block4;
                }
                case UNMARSHALL: {
                    this.unmarshallingTestRunner.runTest(testCase);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported action " + (Object)((Object)testCase.getWhen().getAction()));
        }
    }
}

