/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.runners;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.List;
import org.junit.Assert;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.protocol.model.TestCase;
import software.amazon.awssdk.protocol.reflect.ClientReflector;
import software.amazon.awssdk.protocol.reflect.ShapeModelReflector;
import software.amazon.awssdk.protocol.wiremock.WireMockUtils;
import software.amazon.awssdk.sync.RequestBody;

class MarshallingTestRunner {
    private final IntermediateModel model;
    private final ClientReflector clientReflector;

    MarshallingTestRunner(IntermediateModel model, ClientReflector clientReflector) {
        this.model = model;
        this.clientReflector = clientReflector;
    }

    private static LoggedRequest getLoggedRequest() {
        List<LoggedRequest> requests = WireMockUtils.findAllLoggedRequests();
        Assert.assertEquals((long)1L, (long)requests.size());
        return requests.get(0);
    }

    void runTest(TestCase testCase) throws Exception {
        this.resetWireMock();
        ShapeModelReflector shapeModelReflector = this.createShapeModelReflector(testCase);
        if (!((ShapeModel)this.model.getShapes().get(testCase.getWhen().getOperationName() + "Request")).isHasStreamingMember()) {
            this.clientReflector.invokeMethod(testCase, shapeModelReflector.createShapeObject());
        } else {
            this.clientReflector.invokeMethod(testCase, shapeModelReflector.createShapeObject(), RequestBody.of((String)shapeModelReflector.getStreamingMemberValue()));
        }
        LoggedRequest actualRequest = MarshallingTestRunner.getLoggedRequest();
        testCase.getThen().getMarshallingAssertion().assertMatches(actualRequest);
    }

    private void resetWireMock() {
        WireMock.reset();
        ResponseDefinitionBuilder responseDefBuilder = WireMock.aResponse().withStatus(200);
        if (this.model.getMetadata().isXmlProtocol()) {
            responseDefBuilder.withBody("<foo></foo>");
        }
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlMatchingStrategy)WireMock.urlMatching((String)".*")).willReturn(responseDefBuilder));
    }

    private ShapeModelReflector createShapeModelReflector(TestCase testCase) {
        String operationName = testCase.getWhen().getOperationName();
        String requestClassName = this.getOperationRequestClassName(operationName);
        JsonNode input = testCase.getGiven().getInput();
        return new ShapeModelReflector(this.model, requestClassName, input);
    }

    private String getOperationRequestClassName(String operationName) {
        return operationName + "Request";
    }
}

