/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.profiles.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSupplier;

@SdkInternalApi
public class AggregateProfileFileSupplier
implements ProfileFileSupplier {
    private final List<ProfileFileSupplier> suppliers;
    private final AtomicReference<SupplierState> state = new AtomicReference<SupplierState>(new SupplierState(Collections.emptyMap(), null));

    public AggregateProfileFileSupplier(ProfileFileSupplier ... suppliers) {
        this.suppliers = Collections.unmodifiableList(Arrays.asList(suppliers));
    }

    @Override
    public ProfileFile get() {
        SupplierState currentState = this.state.get();
        Map currentValues = currentState.values;
        Map<Supplier<ProfileFile>, ProfileFile> changedValues = this.changedSupplierValues(currentValues);
        if (changedValues == null) {
            return currentState.aggregate;
        }
        LinkedHashMap<Supplier<ProfileFile>, ProfileFile> nextValues = new LinkedHashMap<Supplier<ProfileFile>, ProfileFile>(currentValues);
        nextValues.putAll(changedValues);
        ProfileFile.Aggregator aggregator = ProfileFile.aggregator();
        nextValues.values().forEach(aggregator::addFile);
        ProfileFile nextAggregate = aggregator.build();
        SupplierState nextState = new SupplierState(nextValues, nextAggregate);
        if (this.state.compareAndSet(currentState, nextState)) {
            return nextAggregate;
        }
        return this.state.get().aggregate;
    }

    private Map<Supplier<ProfileFile>, ProfileFile> changedSupplierValues(Map<Supplier<ProfileFile>, ProfileFile> currentValues) {
        LinkedHashMap<ProfileFileSupplier, ProfileFile> changedValues = null;
        for (ProfileFileSupplier supplier : this.suppliers) {
            ProfileFile next = (ProfileFile)supplier.get();
            ProfileFile prev = currentValues.get(supplier);
            if (prev == next) continue;
            if (changedValues == null) {
                changedValues = new LinkedHashMap<ProfileFileSupplier, ProfileFile>();
            }
            changedValues.put(supplier, next);
        }
        return changedValues;
    }

    private static final class SupplierState {
        private final Map<Supplier<ProfileFile>, ProfileFile> values;
        private final ProfileFile aggregate;

        private SupplierState(Map<Supplier<ProfileFile>, ProfileFile> values, ProfileFile aggregate) {
            this.values = values;
            this.aggregate = aggregate;
        }
    }
}

