/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.profiles;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileLocation;
import software.amazon.awssdk.profiles.internal.AggregateProfileFileSupplier;
import software.amazon.awssdk.profiles.internal.ProfileFileRefresher;

@FunctionalInterface
@SdkPublicApi
public interface ProfileFileSupplier
extends Supplier<ProfileFile> {
    public static ProfileFileSupplier defaultSupplier() {
        Optional<ProfileFileSupplier> credentialsSupplierOptional = ProfileFileLocation.credentialsFileLocation().map(path -> ProfileFileSupplier.reloadWhenModified(path, ProfileFile.Type.CREDENTIALS));
        Optional<ProfileFileSupplier> configurationSupplierOptional = ProfileFileLocation.configurationFileLocation().map(path -> ProfileFileSupplier.reloadWhenModified(path, ProfileFile.Type.CONFIGURATION));
        ProfileFileSupplier supplier = credentialsSupplierOptional.isPresent() && configurationSupplierOptional.isPresent() ? ProfileFileSupplier.aggregate(credentialsSupplierOptional.get(), configurationSupplierOptional.get()) : (credentialsSupplierOptional.isPresent() ? credentialsSupplierOptional.get() : (configurationSupplierOptional.isPresent() ? configurationSupplierOptional.get() : ProfileFileSupplier.fixedProfileFile(ProfileFile.empty())));
        return supplier;
    }

    public static ProfileFileSupplier reloadWhenModified(final Path path, final ProfileFile.Type type) {
        return new ProfileFileSupplier(){
            Supplier<ProfileFile> profileFileSupplier = () -> {
                if (Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path)) {
                    return ProfileFile.builder().content(path).type(type).build();
                }
                return ProfileFile.empty();
            };
            final ProfileFileRefresher refresher = ProfileFileRefresher.builder().profileFile(this.profileFileSupplier).profileFilePath(path).build();

            @Override
            public ProfileFile get() {
                return this.refresher.refreshIfStale();
            }
        };
    }

    public static ProfileFileSupplier fixedProfileFile(ProfileFile profileFile) {
        return () -> profileFile;
    }

    public static ProfileFileSupplier aggregate(ProfileFileSupplier ... suppliers) {
        return new AggregateProfileFileSupplier(suppliers);
    }
}

