/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pricing.model.AttributeValue;
import software.amazon.awssdk.services.pricing.model.AttributeValueListCopier;
import software.amazon.awssdk.services.pricing.model.PricingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAttributeValuesResponse
extends PricingResponse
implements ToCopyableBuilder<Builder, GetAttributeValuesResponse> {
    private static final SdkField<List<AttributeValue>> ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAttributeValuesResponse.getter(GetAttributeValuesResponse::attributeValues)).setter(GetAttributeValuesResponse.setter(Builder::attributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAttributeValuesResponse.getter(GetAttributeValuesResponse::nextToken)).setter(GetAttributeValuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_VALUES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AttributeValue> attributeValues;
    private final String nextToken;

    private GetAttributeValuesResponse(BuilderImpl builder) {
        super(builder);
        this.attributeValues = builder.attributeValues;
        this.nextToken = builder.nextToken;
    }

    public List<AttributeValue> attributeValues() {
        return this.attributeValues;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttributeValuesResponse)) {
            return false;
        }
        GetAttributeValuesResponse other = (GetAttributeValuesResponse)((Object)obj);
        return Objects.equals(this.attributeValues(), other.attributeValues()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetAttributeValuesResponse").add("AttributeValues", this.attributeValues()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeValues": {
                return Optional.ofNullable(clazz.cast(this.attributeValues()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAttributeValuesResponse, T> g) {
        return obj -> g.apply((GetAttributeValuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PricingResponse.BuilderImpl
    implements Builder {
        private List<AttributeValue> attributeValues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAttributeValuesResponse model) {
            super(model);
            this.attributeValues(model.attributeValues);
            this.nextToken(model.nextToken);
        }

        public final Collection<AttributeValue.Builder> getAttributeValues() {
            return this.attributeValues != null ? (Collection)this.attributeValues.stream().map(AttributeValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeValues(Collection<AttributeValue> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(AttributeValue ... attributeValues) {
            this.attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(Consumer<AttributeValue.Builder> ... attributeValues) {
            this.attributeValues(Stream.of(attributeValues).map(c -> (AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeValues(Collection<AttributeValue.BuilderImpl> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copyFromBuilder(attributeValues);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetAttributeValuesResponse build() {
            return new GetAttributeValuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PricingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAttributeValuesResponse> {
        public Builder attributeValues(Collection<AttributeValue> var1);

        public Builder attributeValues(AttributeValue ... var1);

        public Builder attributeValues(Consumer<AttributeValue.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

