/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pricing.PricingAsyncClient;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;

public class DescribeServicesPublisher
implements SdkPublisher<DescribeServicesResponse> {
    private final PricingAsyncClient client;
    private final DescribeServicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeServicesPublisher(PricingAsyncClient client, DescribeServicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeServicesPublisher(PricingAsyncClient client, DescribeServicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeServicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeServicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeServicesResponseFetcher
    implements AsyncPageFetcher<DescribeServicesResponse> {
        private DescribeServicesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeServicesResponse> nextPage(DescribeServicesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServicesPublisher.this.client.describeServices(DescribeServicesPublisher.this.firstRequest);
            }
            return DescribeServicesPublisher.this.client.describeServices((DescribeServicesRequest)((Object)DescribeServicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

