/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.PricingServiceClientConfiguration;
import software.amazon.awssdk.services.pricing.internal.PricingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.pricing.model.AccessDeniedException;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;
import software.amazon.awssdk.services.pricing.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;
import software.amazon.awssdk.services.pricing.model.GetPriceListFileUrlRequest;
import software.amazon.awssdk.services.pricing.model.GetPriceListFileUrlResponse;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;
import software.amazon.awssdk.services.pricing.model.InternalErrorException;
import software.amazon.awssdk.services.pricing.model.InvalidNextTokenException;
import software.amazon.awssdk.services.pricing.model.InvalidParameterException;
import software.amazon.awssdk.services.pricing.model.ListPriceListsRequest;
import software.amazon.awssdk.services.pricing.model.ListPriceListsResponse;
import software.amazon.awssdk.services.pricing.model.NotFoundException;
import software.amazon.awssdk.services.pricing.model.PricingException;
import software.amazon.awssdk.services.pricing.model.ResourceNotFoundException;
import software.amazon.awssdk.services.pricing.model.ThrottlingException;
import software.amazon.awssdk.services.pricing.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.GetAttributeValuesRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.GetPriceListFileUrlRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.GetProductsRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.ListPriceListsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultPricingClient
implements PricingClient {
    private static final Logger log = Logger.loggerFor(DefaultPricingClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPricingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Pricing#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServicesResponse describeServices(DescribeServicesRequest describeServicesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ThrottlingException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPricingClient.resolveMetricPublishers(clientConfiguration, describeServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pricing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServices");
            DescribeServicesResponse describeServicesResponse = (DescribeServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPricingClient.lambda$describeServices$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAttributeValuesResponse getAttributeValues(GetAttributeValuesRequest getAttributeValuesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ThrottlingException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAttributeValuesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAttributeValuesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPricingClient.resolveMetricPublishers(clientConfiguration, getAttributeValuesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pricing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAttributeValues");
            GetAttributeValuesResponse getAttributeValuesResponse = (GetAttributeValuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAttributeValues").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAttributeValuesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAttributeValuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAttributeValuesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPricingClient.lambda$getAttributeValues$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPriceListFileUrlResponse getPriceListFileUrl(GetPriceListFileUrlRequest getPriceListFileUrlRequest) throws InvalidParameterException, NotFoundException, AccessDeniedException, InternalErrorException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, PricingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPriceListFileUrlResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPriceListFileUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPricingClient.resolveMetricPublishers(clientConfiguration, getPriceListFileUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pricing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPriceListFileUrl");
            GetPriceListFileUrlResponse getPriceListFileUrlResponse = (GetPriceListFileUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPriceListFileUrl").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPriceListFileUrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPriceListFileUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPriceListFileUrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPricingClient.lambda$getPriceListFileUrl$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetProductsResponse getProducts(GetProductsRequest getProductsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ThrottlingException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProductsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getProductsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPricingClient.resolveMetricPublishers(clientConfiguration, getProductsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pricing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetProducts");
            GetProductsResponse getProductsResponse = (GetProductsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProducts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getProductsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetProductsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getProductsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPricingClient.lambda$getProducts$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPriceListsResponse listPriceLists(ListPriceListsRequest listPriceListsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, AccessDeniedException, InternalErrorException, ThrottlingException, ResourceNotFoundException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPriceListsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ExpiredNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredNextTokenException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPriceListsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPricingClient.resolveMetricPublishers(clientConfiguration, listPriceListsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pricing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPriceLists");
            ListPriceListsResponse listPriceListsResponse = (ListPriceListsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPriceLists").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPriceListsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPriceListsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPriceListsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPricingClient.lambda$listPriceLists$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "pricing";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        PricingServiceClientConfigurationBuilder serviceConfigBuilder = new PricingServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PricingException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final PricingServiceClientConfiguration serviceClientConfiguration() {
        return new PricingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$listPriceLists$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getProducts$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPriceListFileUrl$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAttributeValues$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServices$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

