/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.internal.UserAgentUtils;
import software.amazon.awssdk.services.pricing.model.ListPriceListsRequest;
import software.amazon.awssdk.services.pricing.model.ListPriceListsResponse;
import software.amazon.awssdk.services.pricing.model.PriceList;

public class ListPriceListsIterable
implements SdkIterable<ListPriceListsResponse> {
    private final PricingClient client;
    private final ListPriceListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPriceListsIterable(PricingClient client, ListPriceListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPriceListsResponseFetcher();
    }

    public Iterator<ListPriceListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PriceList> priceLists() {
        Function<ListPriceListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.priceLists() != null) {
                return response.priceLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPriceListsResponseFetcher
    implements SyncPageFetcher<ListPriceListsResponse> {
        private ListPriceListsResponseFetcher() {
        }

        public boolean hasNextPage(ListPriceListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPriceListsResponse nextPage(ListPriceListsResponse previousPage) {
            if (previousPage == null) {
                return ListPriceListsIterable.this.client.listPriceLists(ListPriceListsIterable.this.firstRequest);
            }
            return ListPriceListsIterable.this.client.listPriceLists((ListPriceListsRequest)((Object)ListPriceListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

