/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.pricing.DefaultPricingClientBuilder;
import software.amazon.awssdk.services.pricing.PricingClientBuilder;
import software.amazon.awssdk.services.pricing.PricingServiceClientConfiguration;
import software.amazon.awssdk.services.pricing.model.AccessDeniedException;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;
import software.amazon.awssdk.services.pricing.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;
import software.amazon.awssdk.services.pricing.model.GetPriceListFileUrlRequest;
import software.amazon.awssdk.services.pricing.model.GetPriceListFileUrlResponse;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;
import software.amazon.awssdk.services.pricing.model.InternalErrorException;
import software.amazon.awssdk.services.pricing.model.InvalidNextTokenException;
import software.amazon.awssdk.services.pricing.model.InvalidParameterException;
import software.amazon.awssdk.services.pricing.model.ListPriceListsRequest;
import software.amazon.awssdk.services.pricing.model.ListPriceListsResponse;
import software.amazon.awssdk.services.pricing.model.NotFoundException;
import software.amazon.awssdk.services.pricing.model.PricingException;
import software.amazon.awssdk.services.pricing.paginators.DescribeServicesIterable;
import software.amazon.awssdk.services.pricing.paginators.GetAttributeValuesIterable;
import software.amazon.awssdk.services.pricing.paginators.GetProductsIterable;
import software.amazon.awssdk.services.pricing.paginators.ListPriceListsIterable;

@SdkPublicApi
@ThreadSafe
public interface PricingClient
extends AwsClient {
    public static final String SERVICE_NAME = "pricing";
    public static final String SERVICE_METADATA_ID = "api.pricing";

    default public DescribeServicesResponse describeServices() throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.describeServices((DescribeServicesRequest)((Object)DescribeServicesRequest.builder().build()));
    }

    default public DescribeServicesResponse describeServices(DescribeServicesRequest describeServicesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        throw new UnsupportedOperationException();
    }

    default public DescribeServicesResponse describeServices(Consumer<DescribeServicesRequest.Builder> describeServicesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.describeServices((DescribeServicesRequest)((Object)((DescribeServicesRequest.Builder)DescribeServicesRequest.builder().applyMutation(describeServicesRequest)).build()));
    }

    default public DescribeServicesIterable describeServicesPaginator() throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.describeServicesPaginator((DescribeServicesRequest)((Object)DescribeServicesRequest.builder().build()));
    }

    default public DescribeServicesIterable describeServicesPaginator(DescribeServicesRequest describeServicesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        throw new UnsupportedOperationException();
    }

    default public DescribeServicesIterable describeServicesPaginator(Consumer<DescribeServicesRequest.Builder> describeServicesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.describeServicesPaginator((DescribeServicesRequest)((Object)((DescribeServicesRequest.Builder)DescribeServicesRequest.builder().applyMutation(describeServicesRequest)).build()));
    }

    default public GetAttributeValuesResponse getAttributeValues(GetAttributeValuesRequest getAttributeValuesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        throw new UnsupportedOperationException();
    }

    default public GetAttributeValuesResponse getAttributeValues(Consumer<GetAttributeValuesRequest.Builder> getAttributeValuesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.getAttributeValues((GetAttributeValuesRequest)((Object)((GetAttributeValuesRequest.Builder)GetAttributeValuesRequest.builder().applyMutation(getAttributeValuesRequest)).build()));
    }

    default public GetAttributeValuesIterable getAttributeValuesPaginator(GetAttributeValuesRequest getAttributeValuesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        throw new UnsupportedOperationException();
    }

    default public GetAttributeValuesIterable getAttributeValuesPaginator(Consumer<GetAttributeValuesRequest.Builder> getAttributeValuesRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.getAttributeValuesPaginator((GetAttributeValuesRequest)((Object)((GetAttributeValuesRequest.Builder)GetAttributeValuesRequest.builder().applyMutation(getAttributeValuesRequest)).build()));
    }

    default public GetPriceListFileUrlResponse getPriceListFileUrl(GetPriceListFileUrlRequest getPriceListFileUrlRequest) throws InvalidParameterException, NotFoundException, AccessDeniedException, InternalErrorException, AwsServiceException, SdkClientException, PricingException {
        throw new UnsupportedOperationException();
    }

    default public GetPriceListFileUrlResponse getPriceListFileUrl(Consumer<GetPriceListFileUrlRequest.Builder> getPriceListFileUrlRequest) throws InvalidParameterException, NotFoundException, AccessDeniedException, InternalErrorException, AwsServiceException, SdkClientException, PricingException {
        return this.getPriceListFileUrl((GetPriceListFileUrlRequest)((Object)((GetPriceListFileUrlRequest.Builder)GetPriceListFileUrlRequest.builder().applyMutation(getPriceListFileUrlRequest)).build()));
    }

    default public GetProductsResponse getProducts(GetProductsRequest getProductsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        throw new UnsupportedOperationException();
    }

    default public GetProductsResponse getProducts(Consumer<GetProductsRequest.Builder> getProductsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.getProducts((GetProductsRequest)((Object)((GetProductsRequest.Builder)GetProductsRequest.builder().applyMutation(getProductsRequest)).build()));
    }

    default public GetProductsIterable getProductsPaginator(GetProductsRequest getProductsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        throw new UnsupportedOperationException();
    }

    default public GetProductsIterable getProductsPaginator(Consumer<GetProductsRequest.Builder> getProductsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.getProductsPaginator((GetProductsRequest)((Object)((GetProductsRequest.Builder)GetProductsRequest.builder().applyMutation(getProductsRequest)).build()));
    }

    default public ListPriceListsResponse listPriceLists(ListPriceListsRequest listPriceListsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, AccessDeniedException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        throw new UnsupportedOperationException();
    }

    default public ListPriceListsResponse listPriceLists(Consumer<ListPriceListsRequest.Builder> listPriceListsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, AccessDeniedException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.listPriceLists((ListPriceListsRequest)((Object)((ListPriceListsRequest.Builder)ListPriceListsRequest.builder().applyMutation(listPriceListsRequest)).build()));
    }

    default public ListPriceListsIterable listPriceListsPaginator(ListPriceListsRequest listPriceListsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, AccessDeniedException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        throw new UnsupportedOperationException();
    }

    default public ListPriceListsIterable listPriceListsPaginator(Consumer<ListPriceListsRequest.Builder> listPriceListsRequest) throws InvalidParameterException, InvalidNextTokenException, NotFoundException, AccessDeniedException, InternalErrorException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return this.listPriceListsPaginator((ListPriceListsRequest)((Object)((ListPriceListsRequest.Builder)ListPriceListsRequest.builder().applyMutation(listPriceListsRequest)).build()));
    }

    public static PricingClient create() {
        return (PricingClient)PricingClient.builder().build();
    }

    public static PricingClientBuilder builder() {
        return new DefaultPricingClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    default public PricingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

