/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pricing.PricingAsyncClient;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;

public class GetProductsPublisher
implements SdkPublisher<GetProductsResponse> {
    private final PricingAsyncClient client;
    private final GetProductsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetProductsPublisher(PricingAsyncClient client, GetProductsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetProductsPublisher(PricingAsyncClient client, GetProductsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetProductsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetProductsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetProductsResponseFetcher
    implements AsyncPageFetcher<GetProductsResponse> {
        private GetProductsResponseFetcher() {
        }

        public boolean hasNextPage(GetProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetProductsResponse> nextPage(GetProductsResponse previousPage) {
            if (previousPage == null) {
                return GetProductsPublisher.this.client.getProducts(GetProductsPublisher.this.firstRequest);
            }
            return GetProductsPublisher.this.client.getProducts((GetProductsRequest)((Object)GetProductsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

