/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;

public final class GetAttributeValuesPaginator
implements SdkIterable<GetAttributeValuesResponse> {
    private final PricingClient client;
    private final GetAttributeValuesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetAttributeValuesPaginator(PricingClient client, GetAttributeValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetAttributeValuesResponseFetcher();
    }

    public Iterator<GetAttributeValuesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetAttributeValuesResponseFetcher
    implements NextPageFetcher<GetAttributeValuesResponse> {
        private GetAttributeValuesResponseFetcher() {
        }

        public boolean hasNextPage(GetAttributeValuesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetAttributeValuesResponse nextPage(GetAttributeValuesResponse previousPage) {
            if (previousPage == null) {
                return GetAttributeValuesPaginator.this.client.getAttributeValues(GetAttributeValuesPaginator.this.firstRequest);
            }
            return GetAttributeValuesPaginator.this.client.getAttributeValues((GetAttributeValuesRequest)((Object)GetAttributeValuesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

