/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pricing.model.Service;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceMarshaller {
    private static final MarshallingInfo<String> SERVICECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceCode").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeNames").isBinary(false).build();
    private static final ServiceMarshaller INSTANCE = new ServiceMarshaller();

    private ServiceMarshaller() {
    }

    public static ServiceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Service service, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)service, (String)"service");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)service.serviceCode(), SERVICECODE_BINDING);
            protocolMarshaller.marshall(service.attributeNames(), ATTRIBUTENAMES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

