/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pricing.model.FilterType;
import software.amazon.awssdk.services.pricing.transform.FilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filter
implements StructuredPojo,
ToCopyableBuilder<Builder, Filter> {
    private final String type;
    private final String field;
    private final String value;

    private Filter(BuilderImpl builder) {
        this.type = builder.type;
        this.field = builder.field;
        this.value = builder.value;
    }

    public FilterType type() {
        return FilterType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String field() {
        return this.field;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.field());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.field(), other.field()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"Filter").add("Type", (Object)this.typeAsString()).add("Field", (Object)this.field()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Field": {
                return Optional.ofNullable(clazz.cast(this.field()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String field;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            this.type(model.type);
            this.field(model.field);
            this.value(model.value);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FilterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getField() {
            return this.field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final void setField(String field) {
            this.field = field;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public Filter build() {
            return new Filter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Filter> {
        public Builder type(String var1);

        public Builder type(FilterType var1);

        public Builder field(String var1);

        public Builder value(String var1);
    }
}

