/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;

public class DescribeServicesIterable
implements SdkIterable<DescribeServicesResponse> {
    private final PricingClient client;
    private final DescribeServicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeServicesIterable(PricingClient client, DescribeServicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeServicesResponseFetcher();
    }

    public Iterator<DescribeServicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final DescribeServicesIterable resume(DescribeServicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeServicesIterable(this.client, (DescribeServicesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeServicesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeServicesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeServicesResponseFetcher
    implements SyncPageFetcher<DescribeServicesResponse> {
        private DescribeServicesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServicesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeServicesResponse nextPage(DescribeServicesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServicesIterable.this.client.describeServices(DescribeServicesIterable.this.firstRequest);
            }
            return DescribeServicesIterable.this.client.describeServices((DescribeServicesRequest)((Object)DescribeServicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

