/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.config.AwsSyncClientConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;
import software.amazon.awssdk.services.pricing.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;
import software.amazon.awssdk.services.pricing.model.InternalErrorException;
import software.amazon.awssdk.services.pricing.model.InvalidNextTokenException;
import software.amazon.awssdk.services.pricing.model.InvalidParameterException;
import software.amazon.awssdk.services.pricing.model.NotFoundException;
import software.amazon.awssdk.services.pricing.model.PricingException;
import software.amazon.awssdk.services.pricing.paginators.DescribeServicesIterable;
import software.amazon.awssdk.services.pricing.paginators.GetAttributeValuesIterable;
import software.amazon.awssdk.services.pricing.paginators.GetProductsIterable;
import software.amazon.awssdk.services.pricing.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.DescribeServicesResponseUnmarshaller;
import software.amazon.awssdk.services.pricing.transform.GetAttributeValuesRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.GetAttributeValuesResponseUnmarshaller;
import software.amazon.awssdk.services.pricing.transform.GetProductsRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.GetProductsResponseUnmarshaller;

@SdkInternalApi
final class DefaultPricingClient
implements PricingClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final AwsSyncClientConfiguration clientConfiguration;

    protected DefaultPricingClient(AwsSyncClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "pricing";
    }

    @Override
    public DescribeServicesResponse describeServices(DescribeServicesRequest describeServicesRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeServicesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServicesRequest).withMarshaller((Marshaller)new DescribeServicesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeServicesIterable describeServicesPaginator(DescribeServicesRequest describeServicesRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return new DescribeServicesIterable(this, describeServicesRequest);
    }

    @Override
    public GetAttributeValuesResponse getAttributeValues(GetAttributeValuesRequest getAttributeValuesRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAttributeValuesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetAttributeValuesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAttributeValuesRequest).withMarshaller((Marshaller)new GetAttributeValuesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetAttributeValuesIterable getAttributeValuesPaginator(GetAttributeValuesRequest getAttributeValuesRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return new GetAttributeValuesIterable(this, getAttributeValuesRequest);
    }

    @Override
    public GetProductsResponse getProducts(GetProductsRequest getProductsRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProductsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetProductsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getProductsRequest).withMarshaller((Marshaller)new GetProductsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetProductsIterable getProductsPaginator(GetProductsRequest getProductsRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, PricingException {
        return new GetProductsIterable(this, getProductsRequest);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(PricingException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredNextTokenException").withModeledClass(ExpiredNextTokenException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

