/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.config.AwsAsyncClientConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pricing.PricingAsyncClient;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;
import software.amazon.awssdk.services.pricing.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;
import software.amazon.awssdk.services.pricing.model.InternalErrorException;
import software.amazon.awssdk.services.pricing.model.InvalidNextTokenException;
import software.amazon.awssdk.services.pricing.model.InvalidParameterException;
import software.amazon.awssdk.services.pricing.model.NotFoundException;
import software.amazon.awssdk.services.pricing.model.PricingException;
import software.amazon.awssdk.services.pricing.paginators.DescribeServicesPublisher;
import software.amazon.awssdk.services.pricing.paginators.GetAttributeValuesPublisher;
import software.amazon.awssdk.services.pricing.paginators.GetProductsPublisher;
import software.amazon.awssdk.services.pricing.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.DescribeServicesResponseUnmarshaller;
import software.amazon.awssdk.services.pricing.transform.GetAttributeValuesRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.GetAttributeValuesResponseUnmarshaller;
import software.amazon.awssdk.services.pricing.transform.GetProductsRequestMarshaller;
import software.amazon.awssdk.services.pricing.transform.GetProductsResponseUnmarshaller;

@SdkInternalApi
final class DefaultPricingAsyncClient
implements PricingAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultPricingAsyncClient(AwsAsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "pricing";
    }

    @Override
    public CompletableFuture<DescribeServicesResponse> describeServices(DescribeServicesRequest describeServicesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeServicesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeServicesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServicesRequest));
    }

    @Override
    public DescribeServicesPublisher describeServicesPaginator(DescribeServicesRequest describeServicesRequest) {
        return new DescribeServicesPublisher(this, describeServicesRequest);
    }

    @Override
    public CompletableFuture<GetAttributeValuesResponse> getAttributeValues(GetAttributeValuesRequest getAttributeValuesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAttributeValuesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetAttributeValuesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAttributeValuesRequest));
    }

    @Override
    public GetAttributeValuesPublisher getAttributeValuesPaginator(GetAttributeValuesRequest getAttributeValuesRequest) {
        return new GetAttributeValuesPublisher(this, getAttributeValuesRequest);
    }

    @Override
    public CompletableFuture<GetProductsResponse> getProducts(GetProductsRequest getProductsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProductsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetProductsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getProductsRequest));
    }

    @Override
    public GetProductsPublisher getProductsPaginator(GetProductsRequest getProductsRequest) {
        return new GetProductsPublisher(this, getProductsRequest);
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(PricingException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredNextTokenException").withModeledClass(ExpiredNextTokenException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

