/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.polly.model.Engine;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.model.PollyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVoicesRequest
extends PollyRequest
implements ToCopyableBuilder<Builder, DescribeVoicesRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVoicesRequest.getter(DescribeVoicesRequest::engineAsString)).setter(DescribeVoicesRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Engine").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVoicesRequest.getter(DescribeVoicesRequest::languageCodeAsString)).setter(DescribeVoicesRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LanguageCode").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ADDITIONAL_LANGUAGE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeVoicesRequest.getter(DescribeVoicesRequest::includeAdditionalLanguageCodes)).setter(DescribeVoicesRequest.setter(Builder::includeAdditionalLanguageCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("IncludeAdditionalLanguageCodes").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVoicesRequest.getter(DescribeVoicesRequest::nextToken)).setter(DescribeVoicesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, LANGUAGE_CODE_FIELD, INCLUDE_ADDITIONAL_LANGUAGE_CODES_FIELD, NEXT_TOKEN_FIELD));
    private final String engine;
    private final String languageCode;
    private final Boolean includeAdditionalLanguageCodes;
    private final String nextToken;

    private DescribeVoicesRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.languageCode = builder.languageCode;
        this.includeAdditionalLanguageCodes = builder.includeAdditionalLanguageCodes;
        this.nextToken = builder.nextToken;
    }

    public Engine engine() {
        return Engine.fromValue(this.engine);
    }

    public String engineAsString() {
        return this.engine;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public Boolean includeAdditionalLanguageCodes() {
        return this.includeAdditionalLanguageCodes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAdditionalLanguageCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVoicesRequest)) {
            return false;
        }
        DescribeVoicesRequest other = (DescribeVoicesRequest)((Object)obj);
        return Objects.equals(this.engineAsString(), other.engineAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.includeAdditionalLanguageCodes(), other.includeAdditionalLanguageCodes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVoicesRequest").add("Engine", (Object)this.engineAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).add("IncludeAdditionalLanguageCodes", (Object)this.includeAdditionalLanguageCodes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "IncludeAdditionalLanguageCodes": {
                return Optional.ofNullable(clazz.cast(this.includeAdditionalLanguageCodes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVoicesRequest, T> g) {
        return obj -> g.apply((DescribeVoicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PollyRequest.BuilderImpl
    implements Builder {
        private String engine;
        private String languageCode;
        private Boolean includeAdditionalLanguageCodes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVoicesRequest model) {
            super(model);
            this.engine(model.engine);
            this.languageCode(model.languageCode);
            this.includeAdditionalLanguageCodes(model.includeAdditionalLanguageCodes);
            this.nextToken(model.nextToken);
        }

        public final String getEngineAsString() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(Engine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getLanguageCodeAsString() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Boolean getIncludeAdditionalLanguageCodes() {
            return this.includeAdditionalLanguageCodes;
        }

        @Override
        public final Builder includeAdditionalLanguageCodes(Boolean includeAdditionalLanguageCodes) {
            this.includeAdditionalLanguageCodes = includeAdditionalLanguageCodes;
            return this;
        }

        public final void setIncludeAdditionalLanguageCodes(Boolean includeAdditionalLanguageCodes) {
            this.includeAdditionalLanguageCodes = includeAdditionalLanguageCodes;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVoicesRequest build() {
            return new DescribeVoicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PollyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVoicesRequest> {
        public Builder engine(String var1);

        public Builder engine(Engine var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder includeAdditionalLanguageCodes(Boolean var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

