/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.polly.model.Engine;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.model.LexiconNameListCopier;
import software.amazon.awssdk.services.polly.model.OutputFormat;
import software.amazon.awssdk.services.polly.model.PollyRequest;
import software.amazon.awssdk.services.polly.model.SpeechMarkType;
import software.amazon.awssdk.services.polly.model.SpeechMarkTypeListCopier;
import software.amazon.awssdk.services.polly.model.TextType;
import software.amazon.awssdk.services.polly.model.VoiceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSpeechSynthesisTaskRequest
extends PollyRequest
implements ToCopyableBuilder<Builder, StartSpeechSynthesisTaskRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::engineAsString)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::languageCodeAsString)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<List<String>> LEXICON_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LexiconNames").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::lexiconNames)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::lexiconNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexiconNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::outputFormatAsString)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3BucketName").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::outputS3BucketName)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::outputS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3BucketName").build()}).build();
    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3KeyPrefix").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::outputS3KeyPrefix)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::outputS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3KeyPrefix").build()}).build();
    private static final SdkField<String> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SampleRate").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::sampleRate)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleRate").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::snsTopicArn)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<List<String>> SPEECH_MARK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpeechMarkTypes").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::speechMarkTypesAsStrings)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::speechMarkTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeechMarkTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::text)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> TEXT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextType").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::textTypeAsString)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::textType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextType").build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceId").getter(StartSpeechSynthesisTaskRequest.getter(StartSpeechSynthesisTaskRequest::voiceIdAsString)).setter(StartSpeechSynthesisTaskRequest.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, LANGUAGE_CODE_FIELD, LEXICON_NAMES_FIELD, OUTPUT_FORMAT_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD, OUTPUT_S3_KEY_PREFIX_FIELD, SAMPLE_RATE_FIELD, SNS_TOPIC_ARN_FIELD, SPEECH_MARK_TYPES_FIELD, TEXT_FIELD, TEXT_TYPE_FIELD, VOICE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Engine", ENGINE_FIELD);
            this.put("LanguageCode", LANGUAGE_CODE_FIELD);
            this.put("LexiconNames", LEXICON_NAMES_FIELD);
            this.put("OutputFormat", OUTPUT_FORMAT_FIELD);
            this.put("OutputS3BucketName", OUTPUT_S3_BUCKET_NAME_FIELD);
            this.put("OutputS3KeyPrefix", OUTPUT_S3_KEY_PREFIX_FIELD);
            this.put("SampleRate", SAMPLE_RATE_FIELD);
            this.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
            this.put("SpeechMarkTypes", SPEECH_MARK_TYPES_FIELD);
            this.put("Text", TEXT_FIELD);
            this.put("TextType", TEXT_TYPE_FIELD);
            this.put("VoiceId", VOICE_ID_FIELD);
        }
    });
    private final String engine;
    private final String languageCode;
    private final List<String> lexiconNames;
    private final String outputFormat;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;
    private final String sampleRate;
    private final String snsTopicArn;
    private final List<String> speechMarkTypes;
    private final String text;
    private final String textType;
    private final String voiceId;

    private StartSpeechSynthesisTaskRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.languageCode = builder.languageCode;
        this.lexiconNames = builder.lexiconNames;
        this.outputFormat = builder.outputFormat;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.sampleRate = builder.sampleRate;
        this.snsTopicArn = builder.snsTopicArn;
        this.speechMarkTypes = builder.speechMarkTypes;
        this.text = builder.text;
        this.textType = builder.textType;
        this.voiceId = builder.voiceId;
    }

    public final Engine engine() {
        return Engine.fromValue(this.engine);
    }

    public final String engineAsString() {
        return this.engine;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final boolean hasLexiconNames() {
        return this.lexiconNames != null && !(this.lexiconNames instanceof SdkAutoConstructList);
    }

    public final List<String> lexiconNames() {
        return this.lexiconNames;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public final String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public final String sampleRate() {
        return this.sampleRate;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final List<SpeechMarkType> speechMarkTypes() {
        return SpeechMarkTypeListCopier.copyStringToEnum(this.speechMarkTypes);
    }

    public final boolean hasSpeechMarkTypes() {
        return this.speechMarkTypes != null && !(this.speechMarkTypes instanceof SdkAutoConstructList);
    }

    public final List<String> speechMarkTypesAsStrings() {
        return this.speechMarkTypes;
    }

    public final String text() {
        return this.text;
    }

    public final TextType textType() {
        return TextType.fromValue(this.textType);
    }

    public final String textTypeAsString() {
        return this.textType;
    }

    public final VoiceId voiceId() {
        return VoiceId.fromValue(this.voiceId);
    }

    public final String voiceIdAsString() {
        return this.voiceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLexiconNames() ? this.lexiconNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpeechMarkTypes() ? this.speechMarkTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceIdAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSpeechSynthesisTaskRequest)) {
            return false;
        }
        StartSpeechSynthesisTaskRequest other = (StartSpeechSynthesisTaskRequest)((Object)obj);
        return Objects.equals(this.engineAsString(), other.engineAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && this.hasLexiconNames() == other.hasLexiconNames() && Objects.equals(this.lexiconNames(), other.lexiconNames()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && this.hasSpeechMarkTypes() == other.hasSpeechMarkTypes() && Objects.equals(this.speechMarkTypesAsStrings(), other.speechMarkTypesAsStrings()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.textTypeAsString(), other.textTypeAsString()) && Objects.equals(this.voiceIdAsString(), other.voiceIdAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartSpeechSynthesisTaskRequest").add("Engine", (Object)this.engineAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LexiconNames", this.hasLexiconNames() ? this.lexiconNames() : null).add("OutputFormat", (Object)this.outputFormatAsString()).add("OutputS3BucketName", (Object)this.outputS3BucketName()).add("OutputS3KeyPrefix", (Object)this.outputS3KeyPrefix()).add("SampleRate", (Object)this.sampleRate()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("SpeechMarkTypes", this.hasSpeechMarkTypes() ? this.speechMarkTypesAsStrings() : null).add("Text", (Object)this.text()).add("TextType", (Object)this.textTypeAsString()).add("VoiceId", (Object)this.voiceIdAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LexiconNames": {
                return Optional.ofNullable(clazz.cast(this.lexiconNames()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "OutputS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.outputS3BucketName()));
            }
            case "OutputS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputS3KeyPrefix()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SpeechMarkTypes": {
                return Optional.ofNullable(clazz.cast(this.speechMarkTypesAsStrings()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "TextType": {
                return Optional.ofNullable(clazz.cast(this.textTypeAsString()));
            }
            case "VoiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceIdAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartSpeechSynthesisTaskRequest, T> g) {
        return obj -> g.apply((StartSpeechSynthesisTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PollyRequest.BuilderImpl
    implements Builder {
        private String engine;
        private String languageCode;
        private List<String> lexiconNames = DefaultSdkAutoConstructList.getInstance();
        private String outputFormat;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;
        private String sampleRate;
        private String snsTopicArn;
        private List<String> speechMarkTypes = DefaultSdkAutoConstructList.getInstance();
        private String text;
        private String textType;
        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSpeechSynthesisTaskRequest model) {
            super(model);
            this.engine(model.engine);
            this.languageCode(model.languageCode);
            this.lexiconNames(model.lexiconNames);
            this.outputFormat(model.outputFormat);
            this.outputS3BucketName(model.outputS3BucketName);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
            this.sampleRate(model.sampleRate);
            this.snsTopicArn(model.snsTopicArn);
            this.speechMarkTypesWithStrings(model.speechMarkTypes);
            this.text(model.text);
            this.textType(model.textType);
            this.voiceId(model.voiceId);
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(Engine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Collection<String> getLexiconNames() {
            if (this.lexiconNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lexiconNames;
        }

        public final void setLexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
        }

        @Override
        public final Builder lexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexiconNames(String ... lexiconNames) {
            this.lexiconNames(Arrays.asList(lexiconNames));
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final String getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final Collection<String> getSpeechMarkTypes() {
            if (this.speechMarkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.speechMarkTypes;
        }

        public final void setSpeechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
        }

        @Override
        public final Builder speechMarkTypesWithStrings(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypesWithStrings(String ... speechMarkTypes) {
            this.speechMarkTypesWithStrings(Arrays.asList(speechMarkTypes));
            return this;
        }

        @Override
        public final Builder speechMarkTypes(Collection<SpeechMarkType> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copyEnumToString(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypes(SpeechMarkType ... speechMarkTypes) {
            this.speechMarkTypes(Arrays.asList(speechMarkTypes));
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getTextType() {
            return this.textType;
        }

        public final void setTextType(String textType) {
            this.textType = textType;
        }

        @Override
        public final Builder textType(String textType) {
            this.textType = textType;
            return this;
        }

        @Override
        public final Builder textType(TextType textType) {
            this.textType(textType == null ? null : textType.toString());
            return this;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId == null ? null : voiceId.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSpeechSynthesisTaskRequest build() {
            return new StartSpeechSynthesisTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PollyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSpeechSynthesisTaskRequest> {
        public Builder engine(String var1);

        public Builder engine(Engine var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder lexiconNames(Collection<String> var1);

        public Builder lexiconNames(String ... var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder sampleRate(String var1);

        public Builder snsTopicArn(String var1);

        public Builder speechMarkTypesWithStrings(Collection<String> var1);

        public Builder speechMarkTypesWithStrings(String ... var1);

        public Builder speechMarkTypes(Collection<SpeechMarkType> var1);

        public Builder speechMarkTypes(SpeechMarkType ... var1);

        public Builder text(String var1);

        public Builder textType(String var1);

        public Builder textType(TextType var1);

        public Builder voiceId(String var1);

        public Builder voiceId(VoiceId var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

