/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.internal.presigner;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.awscore.endpoint.DualstackEnabledProvider;
import software.amazon.awssdk.awscore.endpoint.FipsEnabledProvider;
import software.amazon.awssdk.awscore.presigner.PresignRequest;
import software.amazon.awssdk.awscore.presigner.PresignedRequest;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.signer.Presigner;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.polly.auth.scheme.PollyAuthSchemeProvider;
import software.amazon.awssdk.services.polly.internal.presigner.model.transform.SynthesizeSpeechRequestMarshaller;
import software.amazon.awssdk.services.polly.model.PollyRequest;
import software.amazon.awssdk.services.polly.presigner.PollyPresigner;
import software.amazon.awssdk.services.polly.presigner.model.PresignedSynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.presigner.model.SynthesizeSpeechPresignRequest;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultPollyPresigner
implements PollyPresigner {
    private static final String SIGNING_NAME = "polly";
    private static final String SERVICE_NAME = "polly";
    private static final Aws4Signer DEFAULT_SIGNER = Aws4Signer.create();
    private final Supplier<ProfileFile> profileFile = ProfileFile::defaultProfileFile;
    private final String profileName = ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
    private final Region region;
    private final IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;
    private final URI endpointOverride;
    private final Boolean dualstackEnabled;
    private final Boolean fipsEnabled;

    private DefaultPollyPresigner(BuilderImpl builder) {
        this.region = builder.region != null ? builder.region : DefaultAwsRegionProviderChain.builder().profileFile(this.profileFile).profileName(this.profileName).build().getRegion();
        this.credentialsProvider = builder.credentialsProvider != null ? builder.credentialsProvider : DefaultCredentialsProvider.builder().profileFile(this.profileFile).profileName(this.profileName).build();
        this.endpointOverride = builder.endpointOverride;
        this.dualstackEnabled = builder.dualstackEnabled != null ? builder.dualstackEnabled : DualstackEnabledProvider.builder().profileFile(this.profileFile).profileName(this.profileName).build().isDualstackEnabled().orElse(false);
        this.fipsEnabled = builder.fipsEnabled != null ? builder.fipsEnabled : FipsEnabledProvider.builder().profileFile(this.profileFile).profileName(this.profileName).build().isFipsEnabled().orElse(false);
    }

    IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider() {
        return this.credentialsProvider;
    }

    public void close() {
        IoUtils.closeIfCloseable(this.credentialsProvider, null);
    }

    public static PollyPresigner.Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public PresignedSynthesizeSpeechRequest presignSynthesizeSpeech(SynthesizeSpeechPresignRequest synthesizeSpeechPresignRequest) {
        return this.presign(PresignedSynthesizeSpeechRequest.builder(), synthesizeSpeechPresignRequest, synthesizeSpeechPresignRequest.synthesizeSpeechRequest(), SynthesizeSpeechRequestMarshaller.getInstance()::marshall).build();
    }

    private <T extends PollyRequest> SdkHttpFullRequest marshallRequest(T request, Function<T, SdkHttpFullRequest.Builder> marshalFn) {
        SdkHttpFullRequest.Builder requestBuilder = marshalFn.apply(request);
        this.applyOverrideHeadersAndQueryParams(requestBuilder, request);
        this.applyEndpoint(requestBuilder);
        return requestBuilder.build();
    }

    private <T extends PresignedRequest.Builder, U extends PollyRequest> T presign(T presignedRequest, PresignRequest presignRequest, U requestToPresign, Function<U, SdkHttpFullRequest.Builder> requestMarshaller) {
        ExecutionAttributes execAttrs = this.createExecutionAttributes(presignRequest, requestToPresign);
        SdkHttpFullRequest marshalledRequest = this.marshallRequest(requestToPresign, requestMarshaller);
        SdkHttpFullRequest signedHttpRequest = this.presignRequest(requestToPresign, marshalledRequest, execAttrs);
        this.initializePresignedRequest(presignedRequest, execAttrs, signedHttpRequest);
        return presignedRequest;
    }

    private void initializePresignedRequest(PresignedRequest.Builder presignedRequest, ExecutionAttributes execAttrs, SdkHttpFullRequest signedHttpRequest) {
        List signedHeadersQueryParam = signedHttpRequest.firstMatchingRawQueryParameters("X-Amz-SignedHeaders");
        Map<String, List> signedHeaders = signedHeadersQueryParam.stream().flatMap(h -> Stream.of(h.split(";"))).collect(Collectors.toMap(h -> h, h -> signedHttpRequest.firstMatchingHeader(h).map(Collections::singletonList).orElseGet(ArrayList::new)));
        boolean isBrowserExecutable = signedHttpRequest.method() == SdkHttpMethod.GET && (signedHeaders.isEmpty() || signedHeaders.size() == 1 && signedHeaders.containsKey("host"));
        presignedRequest.expiration((Instant)execAttrs.getAttribute(AwsSignerExecutionAttribute.PRESIGNER_EXPIRATION)).isBrowserExecutable(Boolean.valueOf(isBrowserExecutable)).httpRequest((SdkHttpRequest)signedHttpRequest).signedHeaders(signedHeaders);
    }

    private SdkHttpFullRequest presignRequest(PollyRequest requestToPresign, SdkHttpFullRequest marshalledRequest, ExecutionAttributes executionAttributes) {
        Presigner presigner = this.resolvePresigner(requestToPresign);
        SdkHttpFullRequest presigned = presigner.presign(marshalledRequest, executionAttributes);
        List signedHeadersQueryParam = presigned.firstMatchingRawQueryParameters("X-Amz-SignedHeaders");
        Validate.validState((!signedHeadersQueryParam.isEmpty() ? 1 : 0) != 0, (String)"Only SigV4 presigners are supported at this time, but the configured presigner (%s) did not seem to generate a SigV4 signature.", (Object[])new Object[]{presigner});
        return presigned;
    }

    private ExecutionAttributes createExecutionAttributes(PresignRequest presignRequest, PollyRequest requestToPresign) {
        Instant signatureExpiration = Instant.now().plus(presignRequest.signatureDuration());
        AwsCredentialsIdentity credentials = this.resolveCredentials(this.resolveCredentialsProvider(requestToPresign));
        Validate.validState((credentials != null ? 1 : 0) != 0, (String)"Credential providers must never return null.", (Object[])new Object[0]);
        return new ExecutionAttributes().putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, (Object)CredentialUtils.toCredentials((AwsCredentialsIdentity)credentials)).putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)"polly").putAttribute(AwsExecutionAttribute.AWS_REGION, (Object)this.region).putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, (Object)this.region).putAttribute(SdkInternalExecutionAttribute.IS_FULL_DUPLEX, (Object)false).putAttribute(SdkExecutionAttribute.CLIENT_TYPE, (Object)ClientType.SYNC).putAttribute(SdkExecutionAttribute.SERVICE_NAME, (Object)"polly").putAttribute(AwsSignerExecutionAttribute.PRESIGNER_EXPIRATION, (Object)signatureExpiration).putAttribute(SdkInternalExecutionAttribute.AUTH_SCHEME_RESOLVER, (Object)PollyAuthSchemeProvider.defaultProvider()).putAttribute(SdkInternalExecutionAttribute.AUTH_SCHEMES, this.authSchemes()).putAttribute(SdkInternalExecutionAttribute.IDENTITY_PROVIDERS, IdentityProviders.builder().putIdentityProvider(this.credentialsProvider()).build());
    }

    private Map<String, AuthScheme<?>> authSchemes() {
        AwsV4AuthScheme awsV4AuthScheme = AwsV4AuthScheme.create();
        return Collections.singletonMap(awsV4AuthScheme.schemeId(), awsV4AuthScheme);
    }

    private IdentityProvider<? extends AwsCredentialsIdentity> resolveCredentialsProvider(PollyRequest request) {
        return request.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElse(this.credentialsProvider);
    }

    private AwsCredentialsIdentity resolveCredentials(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
        return (AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)credentialsProvider.resolveIdentity());
    }

    private Presigner resolvePresigner(PollyRequest request) {
        Signer signer = (Signer)request.overrideConfiguration().flatMap(RequestOverrideConfiguration::signer).orElse(DEFAULT_SIGNER);
        return (Presigner)Validate.isInstanceOf(Presigner.class, (Object)signer, (String)"Signer of type %s given in request override is not a Presigner", (Object[])new Object[]{signer.getClass().getSimpleName()});
    }

    private void applyOverrideHeadersAndQueryParams(SdkHttpFullRequest.Builder httpRequestBuilder, PollyRequest request) {
        request.overrideConfiguration().ifPresent(o -> {
            o.headers().forEach((arg_0, arg_1) -> ((SdkHttpFullRequest.Builder)httpRequestBuilder).putHeader(arg_0, arg_1));
            o.rawQueryParameters().forEach((arg_0, arg_1) -> ((SdkHttpFullRequest.Builder)httpRequestBuilder).putRawQueryParameter(arg_0, arg_1));
        });
    }

    private void applyEndpoint(SdkHttpFullRequest.Builder httpRequestBuilder) {
        URI uri = this.resolveEndpoint();
        httpRequestBuilder.protocol(uri.getScheme()).host(uri.getHost()).port(Integer.valueOf(uri.getPort()));
    }

    private URI resolveEndpoint() {
        if (this.endpointOverride != null) {
            return this.endpointOverride;
        }
        return new DefaultServiceEndpointBuilder("polly", "https").withRegion(this.region).withProfileFile(this.profileFile).withProfileName(this.profileName).withDualstackEnabled(this.dualstackEnabled).withFipsEnabled(this.fipsEnabled).getServiceEndpoint();
    }

    public static class BuilderImpl
    implements PollyPresigner.Builder {
        private Region region;
        private IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;
        private URI endpointOverride;
        private Boolean dualstackEnabled;
        private Boolean fipsEnabled;

        @Override
        public PollyPresigner.Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public PollyPresigner.Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            return this.credentialsProvider((IdentityProvider)credentialsProvider);
        }

        @Override
        public PollyPresigner.Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public PollyPresigner.Builder dualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled = dualstackEnabled;
            return this;
        }

        @Override
        public PollyPresigner.Builder fipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
            return this;
        }

        @Override
        public PollyPresigner.Builder endpointOverride(URI endpointOverride) {
            this.endpointOverride = endpointOverride;
            return this;
        }

        @Override
        public PollyPresigner build() {
            return new DefaultPollyPresigner(this);
        }
    }
}

