/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.polly.DefaultPollyAsyncClientBuilder;
import software.amazon.awssdk.services.polly.PollyAsyncClientBuilder;
import software.amazon.awssdk.services.polly.PollyServiceClientConfiguration;
import software.amazon.awssdk.services.polly.model.DeleteLexiconRequest;
import software.amazon.awssdk.services.polly.model.DeleteLexiconResponse;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.GetLexiconRequest;
import software.amazon.awssdk.services.polly.model.GetLexiconResponse;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.ListLexiconsRequest;
import software.amazon.awssdk.services.polly.model.ListLexiconsResponse;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse;
import software.amazon.awssdk.services.polly.model.PutLexiconRequest;
import software.amazon.awssdk.services.polly.model.PutLexiconResponse;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse;
import software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksPublisher;

@SdkPublicApi
@ThreadSafe
public interface PollyAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "polly";
    public static final String SERVICE_METADATA_ID = "polly";

    default public CompletableFuture<DeleteLexiconResponse> deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteLexiconResponse> deleteLexicon(Consumer<DeleteLexiconRequest.Builder> deleteLexiconRequest) {
        return this.deleteLexicon((DeleteLexiconRequest)((Object)((DeleteLexiconRequest.Builder)DeleteLexiconRequest.builder().applyMutation(deleteLexiconRequest)).build()));
    }

    default public CompletableFuture<DescribeVoicesResponse> describeVoices(DescribeVoicesRequest describeVoicesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeVoicesResponse> describeVoices(Consumer<DescribeVoicesRequest.Builder> describeVoicesRequest) {
        return this.describeVoices((DescribeVoicesRequest)((Object)((DescribeVoicesRequest.Builder)DescribeVoicesRequest.builder().applyMutation(describeVoicesRequest)).build()));
    }

    default public CompletableFuture<DescribeVoicesResponse> describeVoices() {
        return this.describeVoices((DescribeVoicesRequest)((Object)DescribeVoicesRequest.builder().build()));
    }

    default public CompletableFuture<GetLexiconResponse> getLexicon(GetLexiconRequest getLexiconRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetLexiconResponse> getLexicon(Consumer<GetLexiconRequest.Builder> getLexiconRequest) {
        return this.getLexicon((GetLexiconRequest)((Object)((GetLexiconRequest.Builder)GetLexiconRequest.builder().applyMutation(getLexiconRequest)).build()));
    }

    default public CompletableFuture<GetSpeechSynthesisTaskResponse> getSpeechSynthesisTask(GetSpeechSynthesisTaskRequest getSpeechSynthesisTaskRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetSpeechSynthesisTaskResponse> getSpeechSynthesisTask(Consumer<GetSpeechSynthesisTaskRequest.Builder> getSpeechSynthesisTaskRequest) {
        return this.getSpeechSynthesisTask((GetSpeechSynthesisTaskRequest)((Object)((GetSpeechSynthesisTaskRequest.Builder)GetSpeechSynthesisTaskRequest.builder().applyMutation(getSpeechSynthesisTaskRequest)).build()));
    }

    default public CompletableFuture<ListLexiconsResponse> listLexicons(ListLexiconsRequest listLexiconsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListLexiconsResponse> listLexicons(Consumer<ListLexiconsRequest.Builder> listLexiconsRequest) {
        return this.listLexicons((ListLexiconsRequest)((Object)((ListLexiconsRequest.Builder)ListLexiconsRequest.builder().applyMutation(listLexiconsRequest)).build()));
    }

    default public CompletableFuture<ListLexiconsResponse> listLexicons() {
        return this.listLexicons((ListLexiconsRequest)((Object)ListLexiconsRequest.builder().build()));
    }

    default public CompletableFuture<ListSpeechSynthesisTasksResponse> listSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest listSpeechSynthesisTasksRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListSpeechSynthesisTasksResponse> listSpeechSynthesisTasks(Consumer<ListSpeechSynthesisTasksRequest.Builder> listSpeechSynthesisTasksRequest) {
        return this.listSpeechSynthesisTasks((ListSpeechSynthesisTasksRequest)((Object)((ListSpeechSynthesisTasksRequest.Builder)ListSpeechSynthesisTasksRequest.builder().applyMutation(listSpeechSynthesisTasksRequest)).build()));
    }

    default public CompletableFuture<ListSpeechSynthesisTasksResponse> listSpeechSynthesisTasks() {
        return this.listSpeechSynthesisTasks((ListSpeechSynthesisTasksRequest)((Object)ListSpeechSynthesisTasksRequest.builder().build()));
    }

    default public ListSpeechSynthesisTasksPublisher listSpeechSynthesisTasksPaginator() {
        return this.listSpeechSynthesisTasksPaginator((ListSpeechSynthesisTasksRequest)((Object)ListSpeechSynthesisTasksRequest.builder().build()));
    }

    default public ListSpeechSynthesisTasksPublisher listSpeechSynthesisTasksPaginator(ListSpeechSynthesisTasksRequest listSpeechSynthesisTasksRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListSpeechSynthesisTasksPublisher listSpeechSynthesisTasksPaginator(Consumer<ListSpeechSynthesisTasksRequest.Builder> listSpeechSynthesisTasksRequest) {
        return this.listSpeechSynthesisTasksPaginator((ListSpeechSynthesisTasksRequest)((Object)((ListSpeechSynthesisTasksRequest.Builder)ListSpeechSynthesisTasksRequest.builder().applyMutation(listSpeechSynthesisTasksRequest)).build()));
    }

    default public CompletableFuture<PutLexiconResponse> putLexicon(PutLexiconRequest putLexiconRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutLexiconResponse> putLexicon(Consumer<PutLexiconRequest.Builder> putLexiconRequest) {
        return this.putLexicon((PutLexiconRequest)((Object)((PutLexiconRequest.Builder)PutLexiconRequest.builder().applyMutation(putLexiconRequest)).build()));
    }

    default public CompletableFuture<StartSpeechSynthesisTaskResponse> startSpeechSynthesisTask(StartSpeechSynthesisTaskRequest startSpeechSynthesisTaskRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartSpeechSynthesisTaskResponse> startSpeechSynthesisTask(Consumer<StartSpeechSynthesisTaskRequest.Builder> startSpeechSynthesisTaskRequest) {
        return this.startSpeechSynthesisTask((StartSpeechSynthesisTaskRequest)((Object)((StartSpeechSynthesisTaskRequest.Builder)StartSpeechSynthesisTaskRequest.builder().applyMutation(startSpeechSynthesisTaskRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, AsyncResponseTransformer<SynthesizeSpeechResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> synthesizeSpeech(Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest, AsyncResponseTransformer<SynthesizeSpeechResponse, ReturnT> asyncResponseTransformer) {
        return this.synthesizeSpeech((SynthesizeSpeechRequest)((Object)((SynthesizeSpeechRequest.Builder)SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<SynthesizeSpeechResponse> synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, Path destinationPath) {
        return this.synthesizeSpeech(synthesizeSpeechRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<SynthesizeSpeechResponse> synthesizeSpeech(Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest, Path destinationPath) {
        return this.synthesizeSpeech((SynthesizeSpeechRequest)((Object)((SynthesizeSpeechRequest.Builder)SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest)).build()), destinationPath);
    }

    public PollyServiceClientConfiguration serviceClientConfiguration();

    public static PollyAsyncClient create() {
        return (PollyAsyncClient)PollyAsyncClient.builder().build();
    }

    public static PollyAsyncClientBuilder builder() {
        return new DefaultPollyAsyncClientBuilder();
    }
}

