/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Description of the voice.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Voice implements SdkPojo, Serializable, ToCopyableBuilder<Voice.Builder, Voice> {
    private static final SdkField<String> GENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Voice::genderAsString)).setter(setter(Builder::gender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gender").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Voice::idAsString)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Voice::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> LANGUAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Voice::languageName)).setter(setter(Builder::languageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Voice::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_LANGUAGE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Voice::additionalLanguageCodesAsStrings))
            .setter(setter(Builder::additionalLanguageCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalLanguageCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_ENGINES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Voice::supportedEnginesAsStrings))
            .setter(setter(Builder::supportedEnginesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENDER_FIELD, ID_FIELD,
            LANGUAGE_CODE_FIELD, LANGUAGE_NAME_FIELD, NAME_FIELD, ADDITIONAL_LANGUAGE_CODES_FIELD, SUPPORTED_ENGINES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String gender;

    private final String id;

    private final String languageCode;

    private final String languageName;

    private final String name;

    private final List<String> additionalLanguageCodes;

    private final List<String> supportedEngines;

    private Voice(BuilderImpl builder) {
        this.gender = builder.gender;
        this.id = builder.id;
        this.languageCode = builder.languageCode;
        this.languageName = builder.languageName;
        this.name = builder.name;
        this.additionalLanguageCodes = builder.additionalLanguageCodes;
        this.supportedEngines = builder.supportedEngines;
    }

    /**
     * <p>
     * Gender of the voice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gender} will
     * return {@link Gender#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #genderAsString}.
     * </p>
     * 
     * @return Gender of the voice.
     * @see Gender
     */
    public Gender gender() {
        return Gender.fromValue(gender);
    }

    /**
     * <p>
     * Gender of the voice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gender} will
     * return {@link Gender#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #genderAsString}.
     * </p>
     * 
     * @return Gender of the voice.
     * @see Gender
     */
    public String genderAsString() {
        return gender;
    }

    /**
     * <p>
     * Amazon Polly assigned voice ID. This is the ID that you specify when calling the <code>SynthesizeSpeech</code>
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #id} will return
     * {@link VoiceId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idAsString}.
     * </p>
     * 
     * @return Amazon Polly assigned voice ID. This is the ID that you specify when calling the
     *         <code>SynthesizeSpeech</code> operation.
     * @see VoiceId
     */
    public VoiceId id() {
        return VoiceId.fromValue(id);
    }

    /**
     * <p>
     * Amazon Polly assigned voice ID. This is the ID that you specify when calling the <code>SynthesizeSpeech</code>
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #id} will return
     * {@link VoiceId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idAsString}.
     * </p>
     * 
     * @return Amazon Polly assigned voice ID. This is the ID that you specify when calling the
     *         <code>SynthesizeSpeech</code> operation.
     * @see VoiceId
     */
    public String idAsString() {
        return id;
    }

    /**
     * <p>
     * Language code of the voice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Language code of the voice.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * Language code of the voice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Language code of the voice.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Human readable name of the language in English.
     * </p>
     * 
     * @return Human readable name of the language in English.
     */
    public String languageName() {
        return languageName;
    }

    /**
     * <p>
     * Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you might
     * display in your application.
     * </p>
     * 
     * @return Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you
     *         might display in your application.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Additional codes for languages available for the specified voice in addition to its default language.
     * </p>
     * <p>
     * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
     * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
     * code <code>hi-IN</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalLanguageCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Additional codes for languages available for the specified voice in addition to its default language.
     *         </p>
     *         <p>
     *         For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
     *         language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show
     *         the code <code>hi-IN</code>.
     */
    public List<LanguageCode> additionalLanguageCodes() {
        return LanguageCodeListCopier.copyStringToEnum(additionalLanguageCodes);
    }

    /**
     * Returns true if the AdditionalLanguageCodes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAdditionalLanguageCodes() {
        return additionalLanguageCodes != null && !(additionalLanguageCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional codes for languages available for the specified voice in addition to its default language.
     * </p>
     * <p>
     * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
     * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
     * code <code>hi-IN</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalLanguageCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Additional codes for languages available for the specified voice in addition to its default language.
     *         </p>
     *         <p>
     *         For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
     *         language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show
     *         the code <code>hi-IN</code>.
     */
    public List<String> additionalLanguageCodesAsStrings() {
        return additionalLanguageCodes;
    }

    /**
     * <p>
     * Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given voice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedEngines()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given
     *         voice.
     */
    public List<Engine> supportedEngines() {
        return EngineListCopier.copyStringToEnum(supportedEngines);
    }

    /**
     * Returns true if the SupportedEngines property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSupportedEngines() {
        return supportedEngines != null && !(supportedEngines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given voice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedEngines()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given
     *         voice.
     */
    public List<String> supportedEnginesAsStrings() {
        return supportedEngines;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(genderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(idAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(additionalLanguageCodesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(supportedEnginesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Voice)) {
            return false;
        }
        Voice other = (Voice) obj;
        return Objects.equals(genderAsString(), other.genderAsString()) && Objects.equals(idAsString(), other.idAsString())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(languageName(), other.languageName()) && Objects.equals(name(), other.name())
                && Objects.equals(additionalLanguageCodesAsStrings(), other.additionalLanguageCodesAsStrings())
                && Objects.equals(supportedEnginesAsStrings(), other.supportedEnginesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Voice").add("Gender", genderAsString()).add("Id", idAsString())
                .add("LanguageCode", languageCodeAsString()).add("LanguageName", languageName()).add("Name", name())
                .add("AdditionalLanguageCodes", additionalLanguageCodesAsStrings())
                .add("SupportedEngines", supportedEnginesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gender":
            return Optional.ofNullable(clazz.cast(genderAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(idAsString()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "LanguageName":
            return Optional.ofNullable(clazz.cast(languageName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AdditionalLanguageCodes":
            return Optional.ofNullable(clazz.cast(additionalLanguageCodesAsStrings()));
        case "SupportedEngines":
            return Optional.ofNullable(clazz.cast(supportedEnginesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Voice, T> g) {
        return obj -> g.apply((Voice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Voice> {
        /**
         * <p>
         * Gender of the voice.
         * </p>
         * 
         * @param gender
         *        Gender of the voice.
         * @see Gender
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Gender
         */
        Builder gender(String gender);

        /**
         * <p>
         * Gender of the voice.
         * </p>
         * 
         * @param gender
         *        Gender of the voice.
         * @see Gender
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Gender
         */
        Builder gender(Gender gender);

        /**
         * <p>
         * Amazon Polly assigned voice ID. This is the ID that you specify when calling the
         * <code>SynthesizeSpeech</code> operation.
         * </p>
         * 
         * @param id
         *        Amazon Polly assigned voice ID. This is the ID that you specify when calling the
         *        <code>SynthesizeSpeech</code> operation.
         * @see VoiceId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceId
         */
        Builder id(String id);

        /**
         * <p>
         * Amazon Polly assigned voice ID. This is the ID that you specify when calling the
         * <code>SynthesizeSpeech</code> operation.
         * </p>
         * 
         * @param id
         *        Amazon Polly assigned voice ID. This is the ID that you specify when calling the
         *        <code>SynthesizeSpeech</code> operation.
         * @see VoiceId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceId
         */
        Builder id(VoiceId id);

        /**
         * <p>
         * Language code of the voice.
         * </p>
         * 
         * @param languageCode
         *        Language code of the voice.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Language code of the voice.
         * </p>
         * 
         * @param languageCode
         *        Language code of the voice.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * Human readable name of the language in English.
         * </p>
         * 
         * @param languageName
         *        Human readable name of the language in English.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageName(String languageName);

        /**
         * <p>
         * Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you
         * might display in your application.
         * </p>
         * 
         * @param name
         *        Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that
         *        you might display in your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Additional codes for languages available for the specified voice in addition to its default language.
         * </p>
         * <p>
         * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
         * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
         * code <code>hi-IN</code>.
         * </p>
         * 
         * @param additionalLanguageCodes
         *        Additional codes for languages available for the specified voice in addition to its default language.
         *        </p>
         *        <p>
         *        For example, the default language for Aditi is Indian English (en-IN) because it was first used for
         *        that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter
         *        would show the code <code>hi-IN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLanguageCodesWithStrings(Collection<String> additionalLanguageCodes);

        /**
         * <p>
         * Additional codes for languages available for the specified voice in addition to its default language.
         * </p>
         * <p>
         * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
         * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
         * code <code>hi-IN</code>.
         * </p>
         * 
         * @param additionalLanguageCodes
         *        Additional codes for languages available for the specified voice in addition to its default language.
         *        </p>
         *        <p>
         *        For example, the default language for Aditi is Indian English (en-IN) because it was first used for
         *        that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter
         *        would show the code <code>hi-IN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLanguageCodesWithStrings(String... additionalLanguageCodes);

        /**
         * <p>
         * Additional codes for languages available for the specified voice in addition to its default language.
         * </p>
         * <p>
         * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
         * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
         * code <code>hi-IN</code>.
         * </p>
         * 
         * @param additionalLanguageCodes
         *        Additional codes for languages available for the specified voice in addition to its default language.
         *        </p>
         *        <p>
         *        For example, the default language for Aditi is Indian English (en-IN) because it was first used for
         *        that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter
         *        would show the code <code>hi-IN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLanguageCodes(Collection<LanguageCode> additionalLanguageCodes);

        /**
         * <p>
         * Additional codes for languages available for the specified voice in addition to its default language.
         * </p>
         * <p>
         * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
         * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
         * code <code>hi-IN</code>.
         * </p>
         * 
         * @param additionalLanguageCodes
         *        Additional codes for languages available for the specified voice in addition to its default language.
         *        </p>
         *        <p>
         *        For example, the default language for Aditi is Indian English (en-IN) because it was first used for
         *        that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter
         *        would show the code <code>hi-IN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLanguageCodes(LanguageCode... additionalLanguageCodes);

        /**
         * <p>
         * Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given voice.
         * </p>
         * 
         * @param supportedEngines
         *        Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given
         *        voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEnginesWithStrings(Collection<String> supportedEngines);

        /**
         * <p>
         * Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given voice.
         * </p>
         * 
         * @param supportedEngines
         *        Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given
         *        voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEnginesWithStrings(String... supportedEngines);

        /**
         * <p>
         * Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given voice.
         * </p>
         * 
         * @param supportedEngines
         *        Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given
         *        voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngines(Collection<Engine> supportedEngines);

        /**
         * <p>
         * Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given voice.
         * </p>
         * 
         * @param supportedEngines
         *        Specifies which engines (<code>standard</code> or <code>neural</code>) that are supported by a given
         *        voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngines(Engine... supportedEngines);
    }

    static final class BuilderImpl implements Builder {
        private String gender;

        private String id;

        private String languageCode;

        private String languageName;

        private String name;

        private List<String> additionalLanguageCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedEngines = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Voice model) {
            gender(model.gender);
            id(model.id);
            languageCode(model.languageCode);
            languageName(model.languageName);
            name(model.name);
            additionalLanguageCodesWithStrings(model.additionalLanguageCodes);
            supportedEnginesWithStrings(model.supportedEngines);
        }

        public final String getGender() {
            return gender;
        }

        @Override
        public final Builder gender(String gender) {
            this.gender = gender;
            return this;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender(gender == null ? null : gender.toString());
            return this;
        }

        public final void setGender(String gender) {
            this.gender = gender;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public final Builder id(VoiceId id) {
            this.id(id == null ? null : id.toString());
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageName() {
            return languageName;
        }

        @Override
        public final Builder languageName(String languageName) {
            this.languageName = languageName;
            return this;
        }

        public final void setLanguageName(String languageName) {
            this.languageName = languageName;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getAdditionalLanguageCodes() {
            return additionalLanguageCodes;
        }

        @Override
        public final Builder additionalLanguageCodesWithStrings(Collection<String> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copy(additionalLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLanguageCodesWithStrings(String... additionalLanguageCodes) {
            additionalLanguageCodesWithStrings(Arrays.asList(additionalLanguageCodes));
            return this;
        }

        @Override
        public final Builder additionalLanguageCodes(Collection<LanguageCode> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copyEnumToString(additionalLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLanguageCodes(LanguageCode... additionalLanguageCodes) {
            additionalLanguageCodes(Arrays.asList(additionalLanguageCodes));
            return this;
        }

        public final void setAdditionalLanguageCodes(Collection<String> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copy(additionalLanguageCodes);
        }

        public final Collection<String> getSupportedEngines() {
            return supportedEngines;
        }

        @Override
        public final Builder supportedEnginesWithStrings(Collection<String> supportedEngines) {
            this.supportedEngines = EngineListCopier.copy(supportedEngines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEnginesWithStrings(String... supportedEngines) {
            supportedEnginesWithStrings(Arrays.asList(supportedEngines));
            return this;
        }

        @Override
        public final Builder supportedEngines(Collection<Engine> supportedEngines) {
            this.supportedEngines = EngineListCopier.copyEnumToString(supportedEngines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngines(Engine... supportedEngines) {
            supportedEngines(Arrays.asList(supportedEngines));
            return this;
        }

        public final void setSupportedEngines(Collection<String> supportedEngines) {
            this.supportedEngines = EngineListCopier.copy(supportedEngines);
        }

        @Override
        public Voice build() {
            return new Voice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
