/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.polly.transform.LexiconMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Lexicon
implements StructuredPojo,
ToCopyableBuilder<Builder, Lexicon> {
    private final String content;
    private final String name;

    private Lexicon(BuilderImpl builder) {
        this.content = builder.content;
        this.name = builder.name;
    }

    public String content() {
        return this.content;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Lexicon)) {
            return false;
        }
        Lexicon other = (Lexicon)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"Lexicon").add("Content", (Object)this.content()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.of(clazz.cast(this.content()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LexiconMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String content;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Lexicon model) {
            this.content(model.content);
            this.name(model.name);
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public Lexicon build() {
            return new Lexicon(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Lexicon> {
        public Builder content(String var1);

        public Builder name(String var1);
    }
}

