/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.polly.model.PollyResponse;
import software.amazon.awssdk.services.polly.model.Voice;
import software.amazon.awssdk.services.polly.model.VoiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVoicesResponse
extends PollyResponse
implements ToCopyableBuilder<Builder, DescribeVoicesResponse> {
    private final List<Voice> voices;
    private final String nextToken;

    private DescribeVoicesResponse(BuilderImpl builder) {
        super(builder);
        this.voices = builder.voices;
        this.nextToken = builder.nextToken;
    }

    public List<Voice> voices() {
        return this.voices;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.voices());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVoicesResponse)) {
            return false;
        }
        DescribeVoicesResponse other = (DescribeVoicesResponse)((Object)obj);
        return Objects.equals(this.voices(), other.voices()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVoicesResponse").add("Voices", this.voices()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Voices": {
                return Optional.of(clazz.cast(this.voices()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PollyResponse.BuilderImpl
    implements Builder {
        private List<Voice> voices;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVoicesResponse model) {
            this.voices(model.voices);
            this.nextToken(model.nextToken);
        }

        public final Collection<Voice.Builder> getVoices() {
            return this.voices != null ? (Collection)this.voices.stream().map(Voice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder voices(Collection<Voice> voices) {
            this.voices = VoiceListCopier.copy(voices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voices(Voice ... voices) {
            this.voices(Arrays.asList(voices));
            return this;
        }

        public final void setVoices(Collection<Voice.BuilderImpl> voices) {
            this.voices = VoiceListCopier.copyFromBuilder(voices);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVoicesResponse build() {
            return new DescribeVoicesResponse(this);
        }
    }

    public static interface Builder
    extends PollyResponse.Builder,
    CopyableBuilder<Builder, DescribeVoicesResponse> {
        public Builder voices(Collection<Voice> var1);

        public Builder voices(Voice ... var1);

        public Builder nextToken(String var1);
    }
}

