/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.polly.model.LexiconAttributes;
import software.amazon.awssdk.services.polly.transform.LexiconDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LexiconDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, LexiconDescription> {
    private final String name;
    private final LexiconAttributes attributes;

    private LexiconDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.attributes = builder.attributes;
    }

    public String name() {
        return this.name;
    }

    public LexiconAttributes attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexiconDescription)) {
            return false;
        }
        LexiconDescription other = (LexiconDescription)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"LexiconDescription").add("Name", (Object)this.name()).add("Attributes", (Object)this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LexiconDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private LexiconAttributes attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(LexiconDescription model) {
            this.name(model.name);
            this.attributes(model.attributes);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final LexiconAttributes.Builder getAttributes() {
            return this.attributes != null ? this.attributes.toBuilder() : null;
        }

        @Override
        public final Builder attributes(LexiconAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final void setAttributes(LexiconAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        public LexiconDescription build() {
            return new LexiconDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LexiconDescription> {
        public Builder name(String var1);

        public Builder attributes(LexiconAttributes var1);

        default public Builder attributes(Consumer<LexiconAttributes.Builder> attributes) {
            return this.attributes((LexiconAttributes)((LexiconAttributes.Builder)LexiconAttributes.builder().apply(attributes)).build());
        }
    }
}

