/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.transform.LexiconAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LexiconAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, LexiconAttributes> {
    private final String alphabet;
    private final String languageCode;
    private final Instant lastModified;
    private final String lexiconArn;
    private final Integer lexemesCount;
    private final Integer size;

    private LexiconAttributes(BuilderImpl builder) {
        this.alphabet = builder.alphabet;
        this.languageCode = builder.languageCode;
        this.lastModified = builder.lastModified;
        this.lexiconArn = builder.lexiconArn;
        this.lexemesCount = builder.lexemesCount;
        this.size = builder.size;
    }

    public String alphabet() {
        return this.alphabet;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeString() {
        return this.languageCode;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String lexiconArn() {
        return this.lexiconArn;
    }

    public Integer lexemesCount() {
        return this.lexemesCount;
    }

    public Integer size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alphabet());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexiconArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexemesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexiconAttributes)) {
            return false;
        }
        LexiconAttributes other = (LexiconAttributes)obj;
        return Objects.equals(this.alphabet(), other.alphabet()) && Objects.equals(this.languageCodeString(), other.languageCodeString()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.lexiconArn(), other.lexiconArn()) && Objects.equals(this.lexemesCount(), other.lexemesCount()) && Objects.equals(this.size(), other.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.alphabet() != null) {
            sb.append("Alphabet: ").append(this.alphabet()).append(",");
        }
        if (this.languageCodeString() != null) {
            sb.append("LanguageCode: ").append(this.languageCodeString()).append(",");
        }
        if (this.lastModified() != null) {
            sb.append("LastModified: ").append(this.lastModified()).append(",");
        }
        if (this.lexiconArn() != null) {
            sb.append("LexiconArn: ").append(this.lexiconArn()).append(",");
        }
        if (this.lexemesCount() != null) {
            sb.append("LexemesCount: ").append(this.lexemesCount()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alphabet": {
                return Optional.of(clazz.cast(this.alphabet()));
            }
            case "LanguageCode": {
                return Optional.of(clazz.cast(this.languageCodeString()));
            }
            case "LastModified": {
                return Optional.of(clazz.cast(this.lastModified()));
            }
            case "LexiconArn": {
                return Optional.of(clazz.cast(this.lexiconArn()));
            }
            case "LexemesCount": {
                return Optional.of(clazz.cast(this.lexemesCount()));
            }
            case "Size": {
                return Optional.of(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LexiconAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String alphabet;
        private String languageCode;
        private Instant lastModified;
        private String lexiconArn;
        private Integer lexemesCount;
        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(LexiconAttributes model) {
            this.alphabet(model.alphabet);
            this.languageCode(model.languageCode);
            this.lastModified(model.lastModified);
            this.lexiconArn(model.lexiconArn);
            this.lexemesCount(model.lexemesCount);
            this.size(model.size);
        }

        public final String getAlphabet() {
            return this.alphabet;
        }

        @Override
        public final Builder alphabet(String alphabet) {
            this.alphabet = alphabet;
            return this;
        }

        public final void setAlphabet(String alphabet) {
            this.alphabet = alphabet;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getLexiconArn() {
            return this.lexiconArn;
        }

        @Override
        public final Builder lexiconArn(String lexiconArn) {
            this.lexiconArn = lexiconArn;
            return this;
        }

        public final void setLexiconArn(String lexiconArn) {
            this.lexiconArn = lexiconArn;
        }

        public final Integer getLexemesCount() {
            return this.lexemesCount;
        }

        @Override
        public final Builder lexemesCount(Integer lexemesCount) {
            this.lexemesCount = lexemesCount;
            return this;
        }

        public final void setLexemesCount(Integer lexemesCount) {
            this.lexemesCount = lexemesCount;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public LexiconAttributes build() {
            return new LexiconAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LexiconAttributes> {
        public Builder alphabet(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder lastModified(Instant var1);

        public Builder lexiconArn(String var1);

        public Builder lexemesCount(Integer var1);

        public Builder size(Integer var1);
    }
}

