/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LanguageCode {
    CY_GB("cy-GB"),
    DA_DK("da-DK"),
    DE_DE("de-DE"),
    EN_AU("en-AU"),
    EN_GB("en-GB"),
    EN_GB_WLS("en-GB-WLS"),
    EN_IN("en-IN"),
    EN_US("en-US"),
    ES_ES("es-ES"),
    ES_US("es-US"),
    FR_CA("fr-CA"),
    FR_FR("fr-FR"),
    IS_IS("is-IS"),
    IT_IT("it-IT"),
    KO_KR("ko-KR"),
    JA_JP("ja-JP"),
    NB_NO("nb-NO"),
    NL_NL("nl-NL"),
    PL_PL("pl-PL"),
    PT_BR("pt-BR"),
    PT_PT("pt-PT"),
    RO_RO("ro-RO"),
    RU_RU("ru-RU"),
    SV_SE("sv-SE"),
    TR_TR("tr-TR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LanguageCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LanguageCode> knownValues() {
        return Stream.of(LanguageCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

